/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.jenkinsci.plugins.electricflow.FileHelper;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ElectricFlowPublishApplication
extends Publisher {
    private static final Log log = LogFactory.getLog(ElectricFlowPublishApplication.class);
    public static final String deploymentPackageName = "deployment_package.zip";
    private static List<File> zipFiles = new ArrayList<File>();
    private static boolean isCutTopLevelDir;
    private final String MANIFEST_NAME = "manifest.json";
    private final String configuration;
    private String filePath;

    @DataBoundConstructor
    public ElectricFlowPublishApplication(String configuration, String artifactName, String filePath) {
        this.configuration = configuration;
        this.filePath = filePath;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException {
        String newFilePath;
        PrintStream logger = listener.getLogger();
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            logger.println("WARNING: Workspace should not be null.");
            log.warn((Object)"Workspace should not be null");
            return false;
        }
        String workspaceDir = workspace.getRemote();
        Integer buildNumber = build.getNumber();
        try {
            EnvReplacer env = new EnvReplacer((Run)build, (TaskListener)listener);
            newFilePath = env.expandEnv(this.filePath);
        }
        catch (IOException | InterruptedException e) {
            logger.println("Unexpected error during expand \"%s\"" + e);
            log.warn((Object)e);
            newFilePath = this.filePath;
        }
        String artifactVersion = buildNumber.toString();
        try {
            ElectricFlowPublishApplication.makeApplicationArchive(build, listener, workspaceDir, newFilePath);
        }
        catch (IOException | InterruptedException e) {
            logger.println("Warning: Cannot create archive: " + e.getMessage());
            log.warn((Object)("Can't create archive: " + e.getMessage()), (Throwable)e);
            return false;
        }
        String artifactGroup = "org.ec";
        String artifactKey = ElectricFlowPublishApplication.getCurrentTimeStamp();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ArtifactKey" + artifactKey));
        }
        String artifactName = artifactGroup + ":" + artifactKey;
        try {
            ElectricFlowClient efClient = new ElectricFlowClient(this.configuration, workspaceDir);
            efClient.uploadArtifact(build, listener, "default", artifactName, artifactVersion, deploymentPackageName, true);
            String deployResponse = efClient.deployApplicationPackage(artifactGroup, artifactKey, artifactVersion, deploymentPackageName);
            String summaryHtml = this.getSummaryHtml(efClient, workspaceDir, logger);
            SummaryTextAction action = new SummaryTextAction((Run<?, ?>)build, summaryHtml);
            build.addAction((Action)action);
            build.save();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DeployApp response: " + deployResponse));
            }
        }
        catch (Exception e) {
            logger.println("Warning: Error occurred during application creation: " + e.getMessage());
            log.warn((Object)("Error occurred during application creation: " + e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(ElectricFlowClient efClient, String workspaceDir, PrintStream logger) {
        String url = efClient.getElectricFlowUrl() + "/flow/#applications";
        String summaryText = "<h3>ElectricFlow Create/Deploy Application from Deployment Package</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Application URL:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(url) + "'>" + HtmlUtils.encodeForHtml(url) + "</a></td>   \n  </tr>\n";
        if (!zipFiles.isEmpty()) {
            StringBuilder strBuilder = new StringBuilder(summaryText);
            strBuilder.append("  <tr>\n    <td><b>Deployment Package Details:</b></td>\n    <td></td>    \n  </tr>\n");
            String jsonContent = "";
            for (File file : zipFiles) {
                String fileName = file.getPath();
                if (isCutTopLevelDir) {
                    fileName = FileHelper.cutTopLevelDir(file.getPath());
                }
                if (fileName.endsWith("manifest.json")) {
                    String manifestPath = FileHelper.buildPath(workspaceDir, "/", fileName);
                    try {
                        byte[] encoded = Files.readAllBytes(Paths.get(manifestPath, new String[0]));
                        jsonContent = new String(encoded, "UTF-8");
                    }
                    catch (IOException e) {
                        logger.println("Warning: Error occurred during read manifest file. " + e.getMessage());
                        log.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                strBuilder.append("  <tr>\n    <td>&nbsp;&nbsp;&nbsp;&nbsp;").append(HtmlUtils.encodeForHtml(fileName)).append("</td>\n    <td>").append("</td>    \n  </tr>\n");
            }
            if (!jsonContent.isEmpty()) {
                strBuilder.append("  <tr>\n    <td>&nbsp;&nbsp;&nbsp;&nbsp;").append(HtmlUtils.encodeForHtml("manifest.json")).append("</td>\n    <td>").append("<pre>").append(HtmlUtils.encodeForHtml(jsonContent)).append("</pre>").append("</td>    \n  </tr>\n");
            }
            summaryText = strBuilder.toString();
        }
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    public static File createZipArchive(String basePath, String archiveName, String[] files) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        for (String file : files) {
            File f = new File(file);
            fileList.add(f);
        }
        return ElectricFlowPublishApplication.createZipArchive(basePath, archiveName, fileList);
    }

    public static File createZipArchive(String basePath, String archiveName, List<File> files) throws IOException {
        return ElectricFlowPublishApplication.createZipArchive(basePath, archiveName, files, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File createZipArchive(String basePath, String archiveName, List<File> files, boolean cutTopLevelDir) throws IOException {
        isCutTopLevelDir = cutTopLevelDir;
        File archive = new File(archiveName);
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(archive));){
            if (cutTopLevelDir) {
                cutTopLevelDir = FileHelper.isTopLevelDirSame(files);
            }
            for (File row : files) {
                try {
                    FileInputStream in = new FileInputStream(FileHelper.buildPath(basePath, "/", row.getPath()));
                    Throwable throwable = null;
                    try {
                        int len;
                        String filePathToAdd = row.getPath();
                        if (cutTopLevelDir) {
                            filePathToAdd = FileHelper.cutTopLevelDir(filePathToAdd);
                        }
                        out.putNextEntry(new ZipEntry(filePathToAdd));
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new IOException("Unable to compress zip file: " + basePath, e);
                    return archive;
                }
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static File createZipArchive(AbstractBuild build, BuildListener listener, String basePath, String archiveName, String path) throws IOException, InterruptedException {
        String fullPath = FileHelper.buildPath(basePath, "/", path);
        File f = new File(fullPath);
        if (f.exists() && f.isDirectory()) {
            List<File> fileList = FileHelper.getFilesFromDirectoryWildcard(build, listener, fullPath, "**");
            ElectricFlowPublishApplication.setZipFiles(fileList);
            return ElectricFlowPublishApplication.createZipArchive(fullPath, archiveName, fileList);
        }
        List<File> filesToArchive = FileHelper.getFilesFromDirectoryWildcard(build, listener, basePath, path);
        ElectricFlowPublishApplication.setZipFiles(filesToArchive);
        return ElectricFlowPublishApplication.createZipArchive(basePath, archiveName, filesToArchive, true);
    }

    public static File makeApplicationArchive(AbstractBuild build, BuildListener listener, String workspaceDir, String filePath) throws IOException, InterruptedException {
        String archivePath = FileHelper.buildPath(workspaceDir, "/", deploymentPackageName);
        return ElectricFlowPublishApplication.createZipArchive(build, listener, workspaceDir, archivePath, filePath);
    }

    public static String getCurrentTimeStamp() {
        String dateFormat = "yyyy-MM-dd-HH-mm-ss.S";
        return new SimpleDateFormat(dateFormat).format(new Date());
    }

    private static void setZipFiles(List<File> fileList) {
        zipFiles.clear();
        zipFiles.addAll(fileList);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String electricFlowUrl;
        private String electricFlowUser;
        private String electricFlowPassword;

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.electricFlowUrl = formData.getString("electricFlowUrl");
            this.electricFlowUser = formData.getString("electricFlowUser");
            this.electricFlowPassword = formData.getString("electricFlowPassword");
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "Configuration");
        }

        public FormValidation doCheckFilePath(@QueryParameter String value, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateValueOnEmpty(value, "File path");
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public String getDisplayName() {
            return "ElectricFlow - Create/Deploy Application from Deployment Package";
        }

        public String getElectricFlowPassword() {
            return this.electricFlowPassword;
        }

        public String getElectricFlowUrl() {
            return this.electricFlowUrl;
        }

        public String getElectricFlowUser() {
            return this.electricFlowUser;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

