/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.HttpMethod;
import org.jenkinsci.plugins.electricflow.Pair;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ElectricFlowGenericRestApi
extends Recorder
implements SimpleBuildStep {
    private String body;
    private String configuration;
    private List<Pair> parameters;
    private String urlPath;
    private String httpMethod;

    @DataBoundConstructor
    public ElectricFlowGenericRestApi(List<Pair> parameters) {
        this.parameters = parameters == null ? new ArrayList<Pair>(0) : new ArrayList<Pair>(parameters);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        try {
            ElectricFlowClient efClient = new ElectricFlowClient(this.configuration);
            String result = efClient.runRestAPI(this.urlPath, HttpMethod.valueOf(this.httpMethod), this.body, this.parameters);
            String summaryHtml = this.getSummaryHtml(efClient, result);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            run.addAction((Action)action);
            run.save();
            taskListener.getLogger().println(Utils.formatJsonOutput(result));
        }
        catch (IOException e) {
            run.setResult(Result.FAILURE);
            throw new IOException(e);
        }
    }

    public String getBody() {
        return this.body;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public List<Pair> getParameters() {
        return this.parameters;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(ElectricFlowClient efClient, String result) throws IOException {
        String url = efClient.getElectricFlowUrl() + this.urlPath;
        String summaryText = "<h3>ElectricFlow Generic REST API</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td style='width:20%;'>URL Path:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(url) + "'>" + HtmlUtils.encodeForHtml(url) + "</a></td>   \n  </tr>\n  <tr>\n    <td>HTTP Method:</td>\n    <td>" + HtmlUtils.encodeForHtml(this.httpMethod) + "</td>   \n  </tr>\n";
        if (!HttpMethod.GET.equals((Object)HttpMethod.valueOf(this.httpMethod))) {
            if (!this.parameters.isEmpty()) {
                StringBuilder strBuilder = new StringBuilder(summaryText);
                strBuilder.append("  <tr>\n    <td>&nbsp;<b>Parameters</b></td>\n    <td></td>    \n  </tr>\n");
                for (Pair pair : this.parameters) {
                    strBuilder.append("  <tr>\n    <td>&nbsp;&nbsp;&nbsp;&nbsp;").append(HtmlUtils.encodeForHtml(pair.getKey())).append(":</td>\n    <td>").append(HtmlUtils.encodeForHtml(pair.getValue())).append("</td>    \n  </tr>\n");
                }
                summaryText = strBuilder.toString();
            } else if (!this.body.isEmpty()) {
                summaryText = summaryText + "  <tr>\n    <td>Body:</td>\n    <td>" + HtmlUtils.encodeForHtml(Utils.formatJsonOutput(this.body)) + "</td>    \n  </tr>\n";
            }
        }
        summaryText = summaryText + "  <tr>\n    <td>Result:</td>\n    <td><pre>" + HtmlUtils.encodeForHtml(Utils.formatJsonOutput(result)) + "</pre></td>    \n  </tr>\n";
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @DataBoundSetter
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @DataBoundSetter
    public void setParameters(List<Pair> parameters) {
        this.parameters = parameters;
    }

    @DataBoundSetter
    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillHttpMethodItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel m = new ListBoxModel();
            m.add("Select HTTP method", "");
            for (HttpMethod httpMethod : HttpMethod.values()) {
                m.add(httpMethod.name(), httpMethod.name());
            }
            return m;
        }

        public String getDisplayName() {
            return "ElectricFlow - Call REST API";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

