/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowDeployApplication
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowDeployApplication.class);
    private String configuration;
    private String projectName;
    private String applicationName;
    private String applicationProcessName;
    private String environmentName;
    private String deployParameters;

    @DataBoundConstructor
    public ElectricFlowDeployApplication() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        boolean isSuccess = this.runProcess(run, taskListener);
        if (!isSuccess) {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean runProcess(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener) {
        ElectricFlowClient efClient = new ElectricFlowClient(this.configuration);
        PrintStream logger = taskListener.getLogger();
        logger.println("Project name: " + this.projectName + ", Application name: " + this.applicationName + ", Application process name: " + this.applicationProcessName + ", Environment name: " + this.environmentName);
        JSONObject runProcess = JSONObject.fromObject((Object)this.deployParameters).getJSONObject("runProcess");
        JSONArray parameter = JSONArray.fromObject((Object)runProcess.getString("parameter"));
        try {
            logger.println("Preparing to run process...");
            String result = efClient.runProcess(this.projectName, this.applicationName, this.applicationProcessName, this.environmentName, parameter);
            JSONObject process = efClient.getProcess(this.projectName, this.applicationName, this.applicationProcessName);
            if (process == null || process.isEmpty()) {
                return false;
            }
            String processId = process.getJSONObject("process").getString("processId");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("applicationName", this.applicationName);
            args.put("processName", this.applicationProcessName);
            args.put("processId", processId);
            args.put("result", result);
            String summaryHtml = this.getSummaryHtml(efClient, parameter, args);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            run.addAction((Action)action);
            run.save();
            logger.println("Deploy application result: " + Utils.formatJsonOutput(result));
        }
        catch (Exception e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getStoredApplicationName() {
        return this.applicationName;
    }

    public String getApplicationProcessName() {
        return this.applicationProcessName;
    }

    public String getStoredApplicationProcessName() {
        return this.applicationProcessName;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public String getDeployParameters() {
        return this.deployParameters;
    }

    public String getStoredDeployParameters() {
        return this.deployParameters;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getStoredEnvironmentName() {
        return this.environmentName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public boolean getValidationTrigger() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(ElectricFlowClient configuration, JSONArray parameters, Map<String, String> args) {
        String result = args.get("result");
        String applicationName = args.get("applicationName");
        String processId = args.get("processId");
        String jobId = JSONObject.fromObject((Object)result).getString("jobId");
        String applicationUrl = configuration.getElectricFlowUrl() + "/flow/#applications/applications";
        String deployRunUrl = configuration.getElectricFlowUrl() + "/flow/#applications/" + processId + "/" + jobId + "/runningProcess";
        String summaryText = "<h3>ElectricFlow Deploy Application</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Application Name:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(applicationUrl) + "'>" + HtmlUtils.encodeForHtml(applicationName) + "</a></td>   \n  </tr>\n  <tr>\n    <td>Deploy run URL:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(deployRunUrl) + "'>" + HtmlUtils.encodeForHtml(deployRunUrl) + "</a></td>   \n  </tr>";
        summaryText = Utils.getParametersHTML(parameters, summaryText, "actualParameterName", "value");
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = SelectFieldUtils.getSelectItemValue(applicationName);
    }

    @DataBoundSetter
    public void setApplicationProcessName(String applicationProcessName) {
        this.applicationProcessName = SelectFieldUtils.getSelectItemValue(applicationProcessName);
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @DataBoundSetter
    public void setDeployParameters(String deployParameters) {
        this.deployParameters = SelectFieldUtils.getSelectItemValue(deployParameters);
    }

    @DataBoundSetter
    public void setEnvironmentName(String environmentName) {
        this.environmentName = SelectFieldUtils.getSelectItemValue(environmentName);
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    @DataBoundSetter
    public void setValidationTrigger(String validationTrigger) {
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckDeployParameters(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckApplicationName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Application name");
        }

        public FormValidation doCheckApplicationProcessName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Application process name");
        }

        public FormValidation doCheckEnvironmentName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Environment name");
        }

        public ListBoxModel doFillApplicationNameItems(@QueryParameter String projectName, @QueryParameter String configuration, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select application", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    ElectricFlowClient client = new ElectricFlowClient(configuration);
                    List<String> applications = client.getApplications(projectName);
                    for (String application : applications) {
                        m.add(application);
                    }
                }
                return m;
            }
            catch (Exception e) {
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching values for this parameter - application. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select application");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select application");
            }
        }

        public ListBoxModel doFillApplicationProcessNameItems(@QueryParameter String configuration, @QueryParameter String projectName, @QueryParameter String applicationName, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select application process", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && !applicationName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName, applicationName)) {
                    ElectricFlowClient client = new ElectricFlowClient(configuration);
                    List<String> processes = client.getProcesses(projectName, applicationName);
                    for (String process : processes) {
                        m.add(process);
                    }
                }
                return m;
            }
            catch (Exception e) {
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching values for this parameter - application process. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select application process");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select application process");
            }
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillDeployParametersItems(@QueryParameter String configuration, @QueryParameter String projectName, @QueryParameter String applicationName, @QueryParameter String applicationProcessName, @QueryParameter String deployParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (configuration.isEmpty() || projectName.isEmpty() || applicationName.isEmpty() || applicationProcessName.isEmpty() || !SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName, applicationName, applicationProcessName)) {
                    m.add("{}");
                    return m;
                }
                ElectricFlowClient client = new ElectricFlowClient(configuration);
                HashMap<String, String> storedParams = new HashMap();
                String deployParametersValue = SelectFieldUtils.getSelectItemValue(deployParameters);
                if (!deployParametersValue.isEmpty() && !"{}".equals(deployParametersValue) && applicationName.equals((jsonArray = (json = JSONObject.fromObject((Object)deployParametersValue)).getJSONObject("runProcess")).get("applicationName")) && applicationProcessName.equals(jsonArray.get("applicationProcessName"))) {
                    storedParams = DescriptorImpl.getParamsMapFromDeployParams(deployParametersValue);
                }
                List<String> parameters = client.getFormalParameters(projectName, applicationName, applicationProcessName);
                JSONObject main = JSONObject.fromObject((Object)("{'runProcess':{'applicationName':'" + applicationName + "', 'applicationProcessName':'" + applicationProcessName + "',   'parameter':[]}}"));
                JSONArray ja = main.getJSONObject("runProcess").getJSONArray("parameter");
                Utils.addParametersToJsonAndPreserveStored(parameters, ja, "actualParameterName", "value", storedParams);
                m.add(main.toString());
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                ListBoxModel m = new ListBoxModel();
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching set of deploy parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of deploy parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of deploy parameters. Connection to Electric Flow Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public ListBoxModel doFillEnvironmentNameItems(@QueryParameter String configuration, @QueryParameter String projectName, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select environment", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    ElectricFlowClient client = new ElectricFlowClient(configuration);
                    List<String> environments = client.getEnvironments(projectName);
                    for (String environment : environments) {
                        m.add(environment);
                    }
                }
                return m;
            }
            catch (Exception e) {
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching values for this parameter - environment. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select environment");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select environment");
            }
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.getProjects(configuration);
        }

        public String getDisplayName() {
            return "ElectricFlow - Deploy Application";
        }

        public String getId() {
            return "electricFlowDeployApplication";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="applicationName") String applicationName, @QueryParameter(value="applicationProcessName") String applicationProcessName, @QueryParameter(value="environmentName") String environmentName, @QueryParameter(value="deployParameters") String deployParameters, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedApplicationName") String storedApplicationName, @QueryParameter(value="storedApplicationProcessName") String storedApplicationProcessName, @QueryParameter(value="storedEnvironmentName") String storedEnvironmentName, @QueryParameter(value="storedDeployParameters") String storedDeployParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String applicationNameValue = SelectFieldUtils.getSelectItemValue(applicationName);
            String applicationProcessNameValue = SelectFieldUtils.getSelectItemValue(applicationProcessName);
            String environmentNameValue = SelectFieldUtils.getSelectItemValue(environmentName);
            String deployParametersValue = SelectFieldUtils.getSelectItemValue(deployParameters);
            Map<String, String> deployParamsMap = DescriptorImpl.getParamsMapFromDeployParams(deployParametersValue);
            Map<String, String> storedDeployParamsMap = DescriptorImpl.getParamsMapFromDeployParams(storedDeployParameters);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Application Name", storedApplicationName, applicationNameValue) + Utils.getValidationComparisonRow("Application Process Name", storedApplicationProcessName, applicationProcessNameValue) + Utils.getValidationComparisonRow("Environment Name", storedEnvironmentName, environmentNameValue) + Utils.getValidationComparisonRowsForExtraParameters("Deploy Parameters", storedDeployParamsMap, deployParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && applicationNameValue.equals(storedApplicationName) && applicationProcessNameValue.equals(storedApplicationProcessName) && environmentNameValue.equals(storedEnvironmentName) && deployParamsMap.equals(storedDeployParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }

        static Map<String, String> getParamsMapFromDeployParams(String deployParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (deployParameters == null || deployParameters.isEmpty() || deployParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)deployParameters);
            if (!json.containsKey((Object)"runProcess") || !json.getJSONObject("runProcess").containsKey((Object)"parameter")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("runProcess").getString("parameter")), "actualParameterName", "value");
        }
    }
}

