/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.utils;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger log = LoggerFactory.getLogger(Shell.class);

    public static Process run(String ... command) {
        return Shell.run(true, command);
    }

    public static Process run(boolean redirectOutputs, String ... command) {
        log.debug("[elastest-plugin]: Running command on the shell -> {}", (Object)Arrays.toString(command));
        try {
            ProcessBuilder p = new ProcessBuilder(command);
            p.redirectErrorStream(true);
            if (redirectOutputs) {
                p.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            return p.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while executing command '" + Arrays.toString(command) + "'", e);
        }
    }

    public static String runAndWaitString(String command) {
        return Shell.runAndWait(command.split(" "));
    }

    public static String runAndWaitArray(String[] command) {
        log.debug("[elastest-plugin]: Running command on the shell -> {}", (Object)Arrays.toString(command));
        String result = Shell.runAndWaitNoLog(command);
        log.info("[elastest-plugin]: Result -> " + result);
        return result;
    }

    public static String runAndWait(String ... command) {
        return Shell.runAndWaitArray(command);
    }

    public static String runAndWaitNoLog(String ... command) {
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
            String output = CharStreams.toString((Readable)new InputStreamReader(p.getInputStream(), "UTF-8"));
            p.destroy();
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception executing command on the shell: " + Arrays.toString(command), e);
        }
    }
}

