/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.action;

import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Run;
import jenkins.plugins.elastest.ElasTestService;
import jenkins.plugins.elastest.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasTestItemMenuAction
extends Actionable
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(ElasTestItemMenuAction.class);
    private static final String ICON_IMAGE = "/plugin/elastest/images/icon.png";
    private String elasTestLogAnalyzerUrl = "http://localhost:4200/#/logmanager";
    private String elasTestTJobExecutionUrl = "";

    public ElasTestItemMenuAction(Run<?, ?> build, String elasTestLogAnalyzerUrl, String elasTestTJobExecutionUrl) {
        LOG.debug("[elastest-plugin]: ElasTest Log Analayser URL: {}", (Object)elasTestLogAnalyzerUrl);
        LOG.debug("[elastest-plugin]: ElasTest TJob execution URL: {}", (Object)elasTestTJobExecutionUrl);
        this.elasTestLogAnalyzerUrl = elasTestLogAnalyzerUrl;
        this.elasTestTJobExecutionUrl = elasTestTJobExecutionUrl;
    }

    public static void addActionToMenu(Run<?, ?> build) {
        ElasTestService elasTestService = ElasTestService.getInstance();
        ElasTestItemMenuAction action = new ElasTestItemMenuAction(build, elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()).getLogAnalyzerUrl(), elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()).getExecutionUrl());
        build.addAction((Action)action);
    }

    public String getDisplayName() {
        return Messages.MenuItemLabel();
    }

    public String getSearchUrl() {
        return null;
    }

    public String getIconFileName() {
        return ICON_IMAGE;
    }

    public String getUrlName() {
        return this.elasTestTJobExecutionUrl;
    }

    public String getElasTestLogAnalyzerUrl() {
        return this.elasTestLogAnalyzerUrl;
    }

    public void setElasTestLogAnalyzerUrl(String elasTestLogAnalyzerUrl) {
        this.elasTestLogAnalyzerUrl = elasTestLogAnalyzerUrl;
    }

    public String getElasTestTJobExecutionUrl() {
        return this.elasTestTJobExecutionUrl;
    }

    public void setElasTestTJobExecutionUrl(String elasTestTJobExecutionUrl) {
        this.elasTestTJobExecutionUrl = elasTestTJobExecutionUrl;
    }
}

