/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.elastest.ElasTestService;
import jenkins.plugins.elastest.Messages;
import jenkins.plugins.elastest.PropertiesService;
import jenkins.plugins.elastest.utils.Utils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasTestInstallation
extends ToolInstallation {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ElasTestInstallation.class);

    @DataBoundConstructor
    public ElasTestInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public static Descriptor getLogstashDescriptor() {
        return (Descriptor)Jenkins.getInstance().getDescriptor(ElasTestInstallation.class);
    }

    @Extension
    public static final class Descriptor
    extends ToolDescriptor<ElasTestInstallation> {
        public String elasTestUrl;
        public String username;
        public String password;
        public String elasTestVersion;

        public Descriptor() {
            this.load();
            this.loadElasTestVersion();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req != null) {
                req.bindJSON((Object)this, formData.getJSONObject("elastest"));
                this.save();
            }
            return super.configure(req, formData);
        }

        public ToolInstallation newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req != null) {
                req.bindJSON((Object)this, formData.getJSONObject("elastest"));
                this.save();
                return (ToolInstallation)super.newInstance(req, formData);
            }
            throw new Descriptor.FormException("Stapler request values null.", "No field.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestElasTestConnection(@QueryParameter(value="elasTestUrl") String elasTestUrl, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            String oldElasTestUrl = this.elasTestUrl;
            String oldUsername = this.username;
            String oldPassword = this.password;
            this.elasTestUrl = elasTestUrl;
            this.username = username;
            this.password = password;
            try {
                if (!username.equals("") && !password.equals("") || username.equals("") && password.equals("")) {
                    block9: {
                        this.loadElasTestVersion();
                        try {
                            ElasTestService elasTestService = ElasTestService.getInstance();
                            if (!Utils.isCompatibleVersions(this.elasTestVersion, elasTestService.getElasTestVersion())) break block9;
                            FormValidation formValidation = FormValidation.ok((String)"Success");
                            return formValidation;
                        }
                        catch (Exception e) {
                            FormValidation formValidation = FormValidation.error((String)"Connection error. Check the ElasTest health and the plugin configuration.");
                            return formValidation;
                        }
                    }
                    FormValidation formValidation = FormValidation.error((String)("Your installed ElasTest version is not compatible with this plugin version. You need to get installed ElasTest v." + this.elasTestVersion + "or later."));
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((String)"To use credentials to access ElasTest, it is necessary to complete both fields, username and password.");
                return formValidation;
            }
            finally {
                this.elasTestUrl = oldElasTestUrl;
                this.username = oldUsername;
                this.password = oldPassword;
            }
        }

        private void loadElasTestVersion() {
            if (this.elasTestVersion == null || this.elasTestVersion.equals("")) {
                try {
                    this.elasTestVersion = PropertiesService.getCompatibleElasTestVersion();
                    LOG.info("[elastest-plugin]: ElasTest version compatible with this plugin version: " + this.elasTestVersion);
                }
                catch (IOException e) {
                    this.elasTestVersion = "Error reading the compatible ElasTest version.";
                }
            }
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doCheckInteger(@QueryParameter(value="value") String value) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.ValueIsInt());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHost(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)Messages.PleaseProvideHost());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckString(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.ValueIsRequired());
            }
            return FormValidation.ok();
        }

        public String getElasTestUrl() {
            return this.elasTestUrl;
        }

        public void setElasTestUrl(String elasTestUrl) {
            this.elasTestUrl = elasTestUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getElasTestVersion() {
            return this.elasTestVersion;
        }

        public void setElasTestVersion(String elasTestVersion) {
            this.elasTestVersion = elasTestVersion;
        }
    }
}

