/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import jenkins.plugins.elastest.ElasTestInstallation;
import jenkins.plugins.elastest.ElasTestService;
import jenkins.plugins.elastest.docker.DockerCommandExecutor;
import jenkins.plugins.elastest.docker.DockerService;
import jenkins.plugins.elastest.json.ElasTestBuild;
import jenkins.plugins.elastest.json.ExternalJob;
import jenkins.plugins.elastest.utils.ParseResultCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class BuildListener
extends RunListener<Run> {
    private static final Logger LOG = LoggerFactory.getLogger(BuildListener.class);
    private String elasTestApiURL;
    private ElasTestService elasTestService;
    private DockerService dockerService;
    private DockerCommandExecutor dockerCommandExecutor;

    public BuildListener() {
        LOG.debug("[elastest-plugin]: Initializing Listener");
        this.elasTestApiURL = ElasTestInstallation.getLogstashDescriptor().elasTestUrl + "/api/external/tjob";
        this.elasTestService = ElasTestService.getInstance();
        this.dockerService = DockerService.getDockerService("unix:///var/run/docker.sock");
        this.dockerCommandExecutor = new DockerCommandExecutor(null, this.dockerService);
    }

    public void onStarted(Run build, TaskListener listener) {
        LOG.debug("[elastest-plugin]: Listener on started");
        super.onStarted(build, listener);
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, hudson.model.BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        LOG.debug(" [elastest-plugin]:Set up environment");
        return super.setUpEnvironment(build, launcher, listener);
    }

    public void onCompleted(Run build, TaskListener listener) {
        super.onCompleted(build, listener);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long timeOnMaster = System.currentTimeMillis();
        ElasTestBuild elasTestBuild = this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName());
        if (elasTestBuild != null && elasTestBuild.getExternalJob() != null && elasTestBuild.getExternalJob().getTestResultFilePattern() != null && !elasTestBuild.getExternalJob().getTestResultFilePattern().isEmpty()) {
            try {
                elasTestBuild.getExternalJob().setTestResults((List)elasTestBuild.getWorkspace().act((FilePath.FileCallable)new ParseResultCallable(elasTestBuild.getExternalJob().getTestResultFilePattern(), buildTime, timeOnMaster)));
            }
            catch (IOException | InterruptedException e) {
                listener.getLogger().println("Error sending surefire reports");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinalized(Run build) {
        super.onFinalized(build);
        System.setProperty("hudson.model.ParametersAction.keepUndefinedParameters", "true");
        if (this.elasTestService.getElasTestBuilds().size() > 0 && build != null && build.getFullDisplayName() != null && build.getResult() != null) {
            ExternalJob externalJob = this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName());
            switch (build.getResult().ordinal) {
                case 0: {
                    externalJob.setResult(0);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    externalJob.setResult(1);
                    break;
                }
                case 4: {
                    externalJob.setResult(3);
                    break;
                }
                default: {
                    externalJob.setResult(0);
                }
            }
            LOG.debug("[elastest-plugin]: Stopping aux containers.");
            ElasTestBuild elasTestBuild = this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName());
            try {
                List<String> buildContainers = this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).getContainers();
                if (buildContainers.size() > 0) {
                    VirtualChannel channel = elasTestBuild.getWorkspace().getChannel();
                    this.dockerCommandExecutor.setCommand("docker", "ps");
                    channel.call((Callable)this.dockerCommandExecutor);
                    for (String containerId : this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).getContainers()) {
                        LOG.info("Stopping docker container: {}", (Object)containerId);
                        this.dockerCommandExecutor.setCommand("docker", "rm", "-f", containerId);
                        channel.call((Callable)this.dockerCommandExecutor);
                    }
                }
            }
            catch (IOException | InterruptedException | RuntimeException io) {
                LOG.warn("[elastest-plugin]: Error stopping monitoring containers. It's possible that you will have to stop them manually");
                io.printStackTrace();
            }
            finally {
                if (elasTestBuild != null && this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).getWriter() != null) {
                    this.elasTestService.manageEIMEndIfNecessary(build, elasTestBuild.getEnvVars());
                    ExecutorService executor = this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).getWriter().getExecutor();
                    if (!executor.isTerminated()) {
                        executor.shutdown();
                        try {
                            executor.awaitTermination(60L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Timeout sending logs to ElasTest");
                        }
                    }
                }
                this.elasTestService.finishElasTestTJobExecution(this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()));
                this.elasTestService.removeExternalJobs(build.getFullDisplayName());
            }
        }
        LOG.info("[elastest-plugin]: Finalized all");
    }
}

