/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm.request;

import hudson.plugins.ec2.win.winrm.request.WinRMRequest;
import hudson.plugins.ec2.win.winrm.soap.HeaderBuilder;
import hudson.plugins.ec2.win.winrm.soap.MessageBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class AbstractWinRMRequest
implements WinRMRequest {
    protected MessageBuilder message = new MessageBuilder();
    protected HeaderBuilder header = this.message.newHeader();
    protected String timeout = "PT60S";
    protected int envelopSize = 153600;
    protected String locale = "en-US";
    protected URL url;

    public AbstractWinRMRequest(URL url) {
        this.url = url;
    }

    protected abstract void construct();

    @Override
    public Document build() {
        this.construct();
        return this.message.build();
    }

    protected HeaderBuilder defaultHeader() throws URISyntaxException {
        return this.header.to(this.url.toURI()).replyTo(new URI("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous")).maxEnvelopeSize(this.envelopSize).id(this.generateUUID()).locale(this.locale).timeout(this.timeout);
    }

    protected void setBody(Element body) {
        this.message.addHeader(this.header.build());
        this.message.addBody(body);
    }

    protected String generateUUID() {
        return "uuid:" + UUID.randomUUID().toString().toUpperCase();
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public int getEnvelopSize() {
        return this.envelopSize;
    }

    public void setEnvelopSize(int envelopSize) {
        this.envelopSize = envelopSize;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

