/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm;

import hudson.plugins.ec2.util.Closeables;
import hudson.plugins.ec2.win.winrm.WinRMClient;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsProcess {
    private static final Logger log = Logger.getLogger(WindowsProcess.class.getName());
    private static final int INPUT_BUFFER = 16384;
    private final WinRMClient client;
    private final FastPipedInputStream toCallersStdin;
    private final FastPipedOutputStream callersStdin;
    private final FastPipedInputStream callersStdout;
    private final FastPipedOutputStream toCallersStdout;
    private final FastPipedInputStream callersStderr;
    private final FastPipedOutputStream toCallersStderr;
    private boolean terminated;
    private final String command;
    private Thread outputThread;
    private Thread inputThread;

    WindowsProcess(WinRMClient client, String command) throws IOException {
        this.client = client;
        this.command = command;
        this.toCallersStdin = new FastPipedInputStream();
        this.callersStdin = new FastPipedOutputStream(this.toCallersStdin);
        this.callersStdout = new FastPipedInputStream();
        this.toCallersStdout = new FastPipedOutputStream(this.callersStdout);
        this.callersStderr = new FastPipedInputStream();
        this.toCallersStderr = new FastPipedOutputStream(this.callersStderr);
        this.startStdoutCopyThread();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.startStdinCopyThread();
    }

    public InputStream getStdout() {
        return this.callersStdout;
    }

    public OutputStream getStdin() {
        return this.callersStdin;
    }

    public InputStream getStderr() {
        return this.callersStderr;
    }

    public synchronized int waitFor() {
        if (this.terminated) {
            return this.client.exitCode();
        }
        try {
            try {
                this.outputThread.join();
            }
            finally {
                this.client.deleteShell();
                this.terminated = true;
                Closeables.closeQuietly((Closeable)this.toCallersStdin);
            }
            return this.client.exitCode();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Exception while executing command", exc);
        }
    }

    public synchronized void destroy() {
        if (this.terminated) {
            return;
        }
        this.client.signal();
        this.client.deleteShell();
        this.terminated = true;
        Closeables.closeQuietly((Closeable)this.toCallersStdout);
        Closeables.closeQuietly((Closeable)this.toCallersStdin);
        Closeables.closeQuietly((Closeable)this.toCallersStderr);
        Closeables.closeQuietly((Closeable)this.callersStdout);
        Closeables.closeQuietly((Closeable)this.callersStdin);
        Closeables.closeQuietly((Closeable)this.callersStderr);
    }

    private void startStdoutCopyThread() {
        this.outputThread = new Thread("output copy: " + this.command){

            @Override
            public void run() {
                try {
                    while (WindowsProcess.this.client.slurpOutput(WindowsProcess.this.toCallersStdout, WindowsProcess.this.toCallersStderr)) {
                    }
                    log.log(Level.FINE, "no more output for " + WindowsProcess.this.command);
                }
                catch (Exception exc) {
                    log.log(Level.WARNING, "ouch, stdout exception for " + WindowsProcess.this.command, exc);
                    exc.printStackTrace();
                }
                finally {
                    Closeables.closeQuietly((Closeable)WindowsProcess.this.toCallersStdout);
                    Closeables.closeQuietly((Closeable)WindowsProcess.this.toCallersStderr);
                }
            }
        };
        this.outputThread.setDaemon(true);
        this.outputThread.start();
    }

    private void startStdinCopyThread() {
        this.inputThread = new Thread("input copy: " + this.command){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n;
                    byte[] buf = new byte[16384];
                    while ((n = WindowsProcess.this.toCallersStdin.read(buf)) != -1) {
                        if (n == 0) continue;
                        byte[] bufToSend = new byte[n];
                        System.arraycopy(buf, 0, bufToSend, 0, n);
                        log.log(Level.FINE, "piping " + bufToSend.length + " to input of " + WindowsProcess.this.command);
                        WindowsProcess.this.client.sendInput(bufToSend);
                    }
                }
                catch (Exception exc) {
                    log.log(Level.WARNING, "ouch, STDIN exception for " + WindowsProcess.this.command, exc);
                }
                finally {
                    Closeables.closeQuietly((Closeable)WindowsProcess.this.callersStdin);
                }
            }
        };
        this.inputThread.setDaemon(true);
        this.inputThread.start();
    }
}

