/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import hudson.plugins.ec2.win.winrm.NegotiateNTLMSchemaFactory;
import hudson.plugins.ec2.win.winrm.RuntimeIOException;
import hudson.plugins.ec2.win.winrm.WinRMConnectException;
import hudson.plugins.ec2.win.winrm.request.RequestFactory;
import hudson.plugins.ec2.win.winrm.soap.Namespaces;
import hudson.remoting.FastPipedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class WinRMClient {
    private static final Logger log = Logger.getLogger(WinRMClient.class.getName());
    private static final String APPLICATION_SOAP_XML = "application/soap+xml";
    private final URL url;
    private final String username;
    private final String password;
    private String shellId;
    private String commandId;
    private int exitCode;
    private SimpleNamespaceContext namespaceContext;
    private final RequestFactory factory;
    private final ThreadLocal<BasicAuthCache> authCache = new ThreadLocal();
    private boolean useHTTPS;
    private BasicCredentialsProvider credsProvider;
    private boolean allowSelfSignedCertificate;

    @Deprecated
    public WinRMClient(URL url, String username, String password) {
        this(url, username, password, false);
    }

    public WinRMClient(URL url, String username, String password, boolean allowSelfSignedCertificate) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.factory = new RequestFactory(url);
        this.allowSelfSignedCertificate = allowSelfSignedCertificate;
        this.setupHTTPClient();
    }

    public void openShell() {
        log.log(Level.FINE, "opening winrm shell to: " + this.url);
        Document request = this.factory.newOpenShellRequest().build();
        this.shellId = WinRMClient.first(this.sendRequest(request), "//*[@Name='ShellId']");
        log.log(Level.FINER, "shellid: " + this.shellId);
    }

    public void executeCommand(String command) {
        log.log(Level.FINE, "winrm execute on " + this.shellId + " command: " + command);
        Document request = this.factory.newExecuteCommandRequest(this.shellId, command).build();
        this.commandId = WinRMClient.first(this.sendRequest(request), "//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":CommandId");
        log.log(Level.FINER, "winrm started execution on " + this.shellId + " commandId: " + this.commandId);
    }

    public void deleteShell() {
        if (this.shellId == null) {
            throw new IllegalStateException("no shell has been created");
        }
        log.log(Level.FINE, "closing winrm shell " + this.shellId);
        Document request = this.factory.newDeleteShellRequest(this.shellId).build();
        this.sendRequest(request);
    }

    public void signal() {
        if (this.commandId == null) {
            throw new IllegalStateException("no command is running");
        }
        log.log(Level.FINE, "signalling winrm shell " + this.shellId + " command: " + this.commandId);
        Document request = this.factory.newSignalRequest(this.shellId, this.commandId).build();
        this.sendRequest(request);
    }

    public void sendInput(byte[] input) {
        log.log(Level.FINE, "--> sending " + input.length);
        Document request = this.factory.newSendInputRequest(input, this.shellId, this.commandId).build();
        this.sendRequest(request);
    }

    public boolean slurpOutput(FastPipedOutputStream stdout, FastPipedOutputStream stderr) throws IOException {
        log.log(Level.FINE, "--> SlurpOutput");
        ImmutableMap streams = ImmutableMap.of((Object)"stdout", (Object)stdout, (Object)"stderr", (Object)stderr);
        Document request = this.factory.newGetOutputRequest(this.shellId, this.commandId).build();
        Document response = this.sendRequest(request);
        XPath xpath = DocumentHelper.createXPath((String)("//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":Stream"));
        this.namespaceContext = new SimpleNamespaceContext();
        this.namespaceContext.addNamespace(Namespaces.NS_WIN_SHELL.getPrefix(), Namespaces.NS_WIN_SHELL.getURI());
        xpath.setNamespaceContext((NamespaceContext)this.namespaceContext);
        for (Object node : xpath.selectNodes((Object)response)) {
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            FastPipedOutputStream stream = (FastPipedOutputStream)streams.get((Object)e.attribute("Name").getText().toLowerCase());
            byte[] decode = Base64.getDecoder().decode(e.getText());
            log.log(Level.FINE, "piping " + decode.length + " bytes from " + e.attribute("Name").getText().toLowerCase());
            stream.write(decode);
        }
        XPath done = DocumentHelper.createXPath((String)"//*[@State='http://schemas.microsoft.com/wbem/wsman/1/windows/shell/CommandState/Done']");
        done.setNamespaceContext((NamespaceContext)this.namespaceContext);
        if (Iterables.isEmpty((Iterable)done.selectNodes((Object)response))) {
            log.log(Level.FINE, "keep going baby!");
            return true;
        }
        this.exitCode = Integer.parseInt(WinRMClient.first(response, "//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":ExitCode"));
        log.log(Level.FINE, "no more output - command is now done - exit code: " + this.exitCode);
        return false;
    }

    public int exitCode() {
        return this.exitCode;
    }

    private static String first(Document doc, String selector) {
        XPath xpath = DocumentHelper.createXPath((String)selector);
        List nodes = xpath.selectNodes((Object)doc);
        if (!nodes.isEmpty() && nodes.get(0) instanceof Element) {
            return ((Node)nodes.get(0)).getText();
        }
        throw new RuntimeException("Malformed response for " + selector + " in " + doc.asXML());
    }

    private void setupHTTPClient() {
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
    }

    private HttpClient buildHTTPClient() {
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
        if (!this.username.contains("\\") && !this.username.contains("/")) {
            Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Negotiate", (Object)new NegotiateNTLMSchemaFactory()).build();
            builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        }
        if (this.useHTTPS) {
            try {
                SSLConnectionSocketFactory sslConnectionFactory;
                if (this.allowSelfSignedCertificate) {
                    sslConnectionFactory = new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    log.log(Level.FINE, "Allowing self-signed certificates");
                } else {
                    sslConnectionFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
                    log.log(Level.FINE, "Using system socket factory");
                }
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
                Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).build();
                BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
                builder.setConnectionManager((HttpClientConnectionManager)ccm);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException sslConnectionFactory) {
                // empty catch block
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(0).build();
        builder.setDefaultRequestConfig(requestConfig);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        builder.setDefaultSocketConfig(socketConfig);
        CloseableHttpClient httpclient = builder.build();
        return httpclient;
    }

    private Document sendRequest(Document request) {
        return this.sendRequest(request, 0);
    }

    private Document sendRequest(Document request, int retry) {
        if (retry > 3) {
            throw new RuntimeException("Too many retry for request");
        }
        HttpClient httpclient = this.buildHTTPClient();
        BasicHttpContext context = new BasicHttpContext();
        if (this.authCache.get() == null) {
            this.authCache.set(new BasicAuthCache());
        }
        context.setAttribute("http.auth.auth-cache", (Object)this.authCache.get());
        try {
            HttpPost post = new HttpPost(this.url.toURI());
            StringEntity entity = new StringEntity(request.asXML(), APPLICATION_SOAP_XML, "UTF-8");
            post.setEntity((HttpEntity)entity);
            log.log(Level.FINEST, "Request:\nPOST " + this.url + "\n" + request.asXML());
            HttpResponse response = httpclient.execute((HttpUriRequest)post, (HttpContext)context);
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (response.getStatusLine().getStatusCode() == 500 && responseEntity.getContentType() != null && entity.getContentType().getValue().startsWith(APPLICATION_SOAP_XML)) {
                    String respStr = EntityUtils.toString((HttpEntity)responseEntity);
                    if (respStr.contains("TimedOut")) {
                        return DocumentHelper.parseText((String)respStr);
                    }
                } else {
                    if (response.getStatusLine().getStatusCode() == 401) {
                        log.log(Level.WARNING, "winrm returned 401 - shouldn't happen though - retrying in 2 minutes");
                        try {
                            Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        this.authCache.set(new BasicAuthCache());
                        log.log(Level.WARNING, "winrm returned 401 - retrying now");
                        return this.sendRequest(request, ++retry);
                    }
                    log.log(Level.WARNING, "winrm service " + this.shellId + " unexpected HTTP Response (" + response.getStatusLine().getReasonPhrase() + "): " + EntityUtils.toString((HttpEntity)response.getEntity()));
                    throw new RuntimeException("Unexpected HTTP response " + response.getStatusLine().getStatusCode() + " on " + this.url + ": " + response.getStatusLine().getReasonPhrase());
                }
            }
            if (responseEntity.getContentType() == null || !entity.getContentType().getValue().startsWith(APPLICATION_SOAP_XML)) {
                throw new RuntimeException("Unexpected WinRM content type: " + entity.getContentType());
            }
            Document responseDocument = DocumentHelper.parseText((String)EntityUtils.toString((HttpEntity)responseEntity));
            log.log(Level.FINEST, "Response:\n" + responseDocument.asXML());
            return responseDocument;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid WinRM URI " + this.url);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid WinRM body " + request.asXML());
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("HTTP Error " + e.getMessage(), e);
        }
        catch (HttpHostConnectException e) {
            log.log(Level.SEVERE, "Can't connect to host", e);
            throw new WinRMConnectException("Can't connect to host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "I/O Exception in HTTP POST", e);
            throw new RuntimeIOException("I/O Exception " + e.getMessage(), e);
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, "XML Parse exception in HTTP POST", e);
            throw new RuntimeException("Unparseable XML in winRM response " + e.getMessage(), e);
        }
        catch (DocumentException e) {
            log.log(Level.SEVERE, "XML Document exception in HTTP POST", e);
            throw new RuntimeException("Invalid XML document in winRM response " + e.getMessage(), e);
        }
    }

    public String getTimeout() {
        return this.factory.getTimeout();
    }

    public void setTimeout(String timeout) {
        this.factory.setTimeout(timeout);
    }

    public void setUseHTTPS(boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }
}

