/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.GetPasswordDataResult;
import com.amazonaws.services.ec2.model.Instance;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.os.WindowsUtil;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.plugins.ec2.EC2HostAddressProvider;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.win.Messages;
import hudson.plugins.ec2.win.WinConnection;
import hudson.plugins.ec2.win.winrm.WindowsProcess;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jvnet.localizer.Localizable;

public class EC2WindowsLauncher
extends EC2ComputerLauncher {
    private static final String AGENT_JAR = "remoting.jar";
    final long sleepBetweenAttempts = TimeUnit.SECONDS.toMillis(10L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchScript(EC2Computer computer, TaskListener listener) throws IOException, AmazonClientException, InterruptedException {
        PrintStream logger = listener.getLogger();
        EC2AbstractSlave node = computer.getNode();
        if (node == null) {
            logger.println("Unable to fetch node information");
            return;
        }
        SlaveTemplate template = computer.getSlaveTemplate();
        if (template == null) {
            throw new IOException("Could not find corresponding slave template for " + computer.getDisplayName());
        }
        try (final WinConnection connection = this.connectToWinRM(computer, node, template, logger);){
            String initScript = node.initScript;
            String tmpDir = node.tmpDir != null && !node.tmpDir.equals("") ? WindowsUtil.quoteArgument(Util.ensureEndsWith((String)node.tmpDir, (String)"\\")) : "C:\\Windows\\Temp\\";
            logger.println("Creating tmp directory if it does not exist");
            WindowsProcess mkdirProcess = connection.execute("if not exist " + tmpDir + " mkdir " + tmpDir);
            int exitCode = mkdirProcess.waitFor();
            if (exitCode != 0) {
                logger.println("Creating tmpdir failed=" + exitCode);
                return;
            }
            if (initScript != null && initScript.trim().length() > 0 && !connection.exists(tmpDir + ".jenkins-init")) {
                logger.println("Executing init script");
                try (OutputStream init = connection.putFile(tmpDir + "init.bat");){
                    init.write(initScript.getBytes("utf-8"));
                }
                WindowsProcess initProcess = connection.execute("cmd /c " + tmpDir + "init.bat");
                IOUtils.copy((InputStream)initProcess.getStdout(), (OutputStream)logger);
                int exitStatus = initProcess.waitFor();
                if (exitStatus != 0) {
                    logger.println("init script failed: exit code=" + exitStatus);
                    return;
                }
                try (OutputStream initGuard = connection.putFile(tmpDir + ".jenkins-init");){
                    initGuard.write("init ran".getBytes(StandardCharsets.UTF_8));
                }
                logger.println("init script ran successfully");
            }
            try (OutputStream agentJar = connection.putFile(tmpDir + AGENT_JAR);){
                agentJar.write(Jenkins.get().getJnlpJars(AGENT_JAR).readFully());
            }
            logger.println("remoting.jar sent remotely. Bootstrapping it");
            String jvmopts = node.jvmopts;
            String remoteFS = WindowsUtil.quoteArgument(node.getRemoteFS());
            String workDir = Util.fixEmptyAndTrim((String)remoteFS) != null ? remoteFS : tmpDir;
            String launchString = "java " + (jvmopts != null ? jvmopts : "") + " -jar " + tmpDir + AGENT_JAR + " -workDir " + workDir;
            logger.println("Launching via WinRM:" + launchString);
            final WindowsProcess process = connection.execute(launchString, 86400);
            computer.setChannel(process.getStdout(), process.getStdin(), logger, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    process.destroy();
                    connection.close();
                }
            });
        }
    }

    @Nonnull
    private WinConnection connectToWinRM(EC2Computer computer, EC2AbstractSlave node, SlaveTemplate template, PrintStream logger) throws AmazonClientException, InterruptedException {
        long minTimeout = 3000L;
        long timeout = node.getLaunchTimeoutInMillis();
        if (timeout < 3000L) {
            timeout = 3000L;
        }
        long startTime = System.currentTimeMillis();
        logger.println(node.getDisplayName() + " booted at " + node.getCreatedTime());
        boolean alreadyBooted = startTime - node.getCreatedTime() > TimeUnit.MINUTES.toMillis(3L);
        WinConnection connection = null;
        while (true) {
            boolean allowSelfSignedCertificate = node.isAllowSelfSignedCertificate();
            try {
                long waitTime = System.currentTimeMillis() - startTime;
                if (waitTime > timeout) {
                    throw new AmazonClientException("Timed out after " + waitTime / 1000L + " seconds of waiting for winrm to be connected");
                }
                if (connection == null) {
                    Instance instance = computer.updateInstanceDescription();
                    String host = EC2HostAddressProvider.windows(instance, template.connectionStrategy);
                    if (host == null || "0.0.0.0".equals(host)) {
                        logger.println("Invalid host (null or 0.0.0.0). Your host is most likely waiting for an IP address.");
                        throw new IOException("goto sleep");
                    }
                    if (!node.isSpecifyPassword()) {
                        GetPasswordDataResult result;
                        try {
                            result = node.getCloud().connect().getPasswordData(new GetPasswordDataRequest(instance.getInstanceId()));
                        }
                        catch (Exception e) {
                            logger.println("Unexpected Exception: " + e.toString());
                            Thread.sleep(this.sleepBetweenAttempts);
                            continue;
                        }
                        String passwordData = result.getPasswordData();
                        if (passwordData == null || passwordData.isEmpty()) {
                            logger.println("Waiting for password to be available. Sleeping 10s.");
                            Thread.sleep(this.sleepBetweenAttempts);
                            continue;
                        }
                        String password = node.getCloud().getPrivateKey().decryptWindowsPassword(passwordData);
                        if (!node.getRemoteAdmin().equals("Administrator")) {
                            logger.println("WARNING: For password retrieval remote admin must be Administrator, ignoring user provided value");
                        }
                        logger.println("Connecting to (" + host + ") with WinRM as Administrator");
                        connection = new WinConnection(host, "Administrator", password, allowSelfSignedCertificate);
                    } else {
                        logger.println("Connecting to (" + host + ") with WinRM as " + node.getRemoteAdmin());
                        connection = new WinConnection(host, node.getRemoteAdmin(), node.getAdminPassword().getPlainText(), allowSelfSignedCertificate);
                    }
                    connection.setUseHTTPS(node.isUseHTTPS());
                }
                if (!connection.pingFailingIfSSHHandShakeError()) {
                    logger.println("Waiting for WinRM to come up. Sleeping 10s.");
                    Thread.sleep(this.sleepBetweenAttempts);
                    continue;
                }
                if (!alreadyBooted || node.stopOnTerminate) {
                    logger.println("WinRM service responded. Waiting for WinRM service to stabilize on " + node.getDisplayName());
                    Thread.sleep(node.getBootDelay());
                    alreadyBooted = true;
                    logger.println("WinRM should now be ok on " + node.getDisplayName());
                    if (!connection.pingFailingIfSSHHandShakeError()) {
                        logger.println("WinRM not yet up. Sleeping 10s.");
                        Thread.sleep(this.sleepBetweenAttempts);
                        continue;
                    }
                }
                logger.println("Connected with WinRM.");
                return connection;
            }
            catch (IOException e) {
                if (e instanceof SSLException) {
                    computer.setTemporarilyOffline(true, OfflineCause.create((Localizable)Messages._OfflineCause_SSLException()));
                    throw new AmazonClientException("The SSL connection failed while negotiating SSL", (Throwable)e);
                }
                logger.println("Waiting for WinRM to come up. Sleeping 10s.");
                Thread.sleep(this.sleepBetweenAttempts);
                continue;
            }
            break;
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

