/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ResettableCountDownLatch {
    private final int count;
    private final AtomicReference<CountDownLatch> latchHolder = new AtomicReference();

    public ResettableCountDownLatch(int count) {
        this(count, true);
    }

    public ResettableCountDownLatch(int count, boolean setInitialState) {
        this.count = count;
        if (setInitialState) {
            this.latchHolder.set(new CountDownLatch(count));
        } else {
            this.latchHolder.set(new CountDownLatch(0));
        }
    }

    public void countDown() {
        this.latchHolder.get().countDown();
    }

    public void reset() {
        this.latchHolder.set(new CountDownLatch(this.count));
    }

    public void await() throws InterruptedException {
        this.latchHolder.get().await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latchHolder.get().await(timeout, unit);
    }

    public long getCount() {
        return this.latchHolder.get().getCount();
    }
}

