/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ebs;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.PeriodicWork;
import hudson.plugins.ec2.ebs.ZPoolExpandNotice;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSFileSystem;
import org.jvnet.solaris.libzfs.ZFSPool;

@Extension
public class ZPoolMonitor
extends PeriodicWork {
    private static Boolean isInsideEC2;

    public long getRecurrencePeriod() {
        return TimeUnit.HOURS.toMillis(1L);
    }

    protected void doRun() {
        ZPoolExpandNotice zen = (ZPoolExpandNotice)((Object)AdministrativeMonitor.all().get(ZPoolExpandNotice.class));
        Jenkins jenkinsInstance = Jenkins.getInstanceOrNull();
        ZFSFileSystem fs = null;
        try {
            if (ZPoolMonitor.isInsideEC2() && jenkinsInstance != null) {
                fs = new LibZFS().getFileSystemByMountPoint(jenkinsInstance.getRootDir());
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (fs == null || zen == null) {
            this.cancel();
            return;
        }
        ZFSPool pool = fs.getPool();
        long a = pool.getAvailableSize();
        long t = pool.getSize();
        zen.activated = t / a > 10L && a < 1000000000L;
    }

    public static synchronized boolean isInsideEC2() {
        if (isInsideEC2 == null) {
            try {
                new URL("http://169.254.169.254/latest").openStream().close();
                isInsideEC2 = true;
            }
            catch (IOException e) {
                isInsideEC2 = false;
            }
        }
        return isInsideEC2;
    }
}

