/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.ec2.ssh.verifiers.AcceptNewStrategy;
import hudson.plugins.ec2.ssh.verifiers.CheckNewHardStrategy;
import hudson.plugins.ec2.ssh.verifiers.CheckNewSoftStrategy;
import hudson.plugins.ec2.ssh.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.ec2.ssh.verifiers.SshHostKeyVerificationStrategy;

public enum HostKeyVerificationStrategyEnum {
    CHECK_NEW_HARD("check-new-hard", "yes", new CheckNewHardStrategy()),
    CHECK_NEW_SOFT("check-new-soft", "accept-new", new CheckNewSoftStrategy()),
    ACCEPT_NEW("accept-new", "accept-new", new AcceptNewStrategy()),
    OFF("off", "off", new NonVerifyingKeyVerificationStrategy());

    private final String displayText;
    private final SshHostKeyVerificationStrategy strategy;
    private final String sshCommandEquivalentFlag;

    private HostKeyVerificationStrategyEnum(@NonNull String displayText, String sshCommandEquivalentFlag, SshHostKeyVerificationStrategy strategy) {
        this.displayText = displayText;
        this.sshCommandEquivalentFlag = sshCommandEquivalentFlag;
        this.strategy = strategy;
    }

    @NonNull
    public SshHostKeyVerificationStrategy getStrategy() {
        return this.strategy;
    }

    public boolean equalsDisplayText(String other) {
        return this.displayText.equals(other);
    }

    @NonNull
    public String getDisplayText() {
        return this.displayText;
    }

    @NonNull
    public String getSshCommandEquivalentFlag() {
        return this.sshCommandEquivalentFlag;
    }
}

