/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MinimumNumberOfInstancesTimeRangeConfig {
    private String minimumNoInstancesActiveTimeRangeFrom;
    private String minimumNoInstancesActiveTimeRangeTo;
    private Map<String, Boolean> minimumNoInstancesActiveTimeRangeDays;

    @DataBoundConstructor
    public MinimumNumberOfInstancesTimeRangeConfig() {
    }

    private static Map<String, Boolean> parseDays(JSONObject days) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("monday", days.getBoolean("monday"));
        map.put("tuesday", days.getBoolean("tuesday"));
        map.put("wednesday", days.getBoolean("wednesday"));
        map.put("thursday", days.getBoolean("thursday"));
        map.put("friday", days.getBoolean("friday"));
        map.put("saturday", days.getBoolean("saturday"));
        map.put("sunday", days.getBoolean("sunday"));
        return map;
    }

    private static LocalTime getLocalTime(String value) {
        try {
            return LocalTime.parse(value, DateTimeFormatter.ofPattern("h:mm a", Locale.ENGLISH));
        }
        catch (DateTimeParseException e) {
            try {
                return LocalTime.parse(value, DateTimeFormatter.ofPattern("HH:mm", Locale.ENGLISH));
            }
            catch (DateTimeParseException dateTimeParseException) {
                return null;
            }
        }
    }

    public static void validateLocalTimeString(String value) {
        if (MinimumNumberOfInstancesTimeRangeConfig.getLocalTime(value) == null) {
            throw new IllegalArgumentException("Value " + value + " is not valid time format, ([h:mm a] or [HH:mm])");
        }
    }

    public String getMinimumNoInstancesActiveTimeRangeFrom() {
        return this.minimumNoInstancesActiveTimeRangeFrom;
    }

    @DataBoundSetter
    public void setMinimumNoInstancesActiveTimeRangeFrom(String minimumNoInstancesActiveTimeRangeFrom) {
        MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(minimumNoInstancesActiveTimeRangeFrom);
        this.minimumNoInstancesActiveTimeRangeFrom = minimumNoInstancesActiveTimeRangeFrom;
    }

    public LocalTime getMinimumNoInstancesActiveTimeRangeFromAsTime() {
        return MinimumNumberOfInstancesTimeRangeConfig.getLocalTime(this.minimumNoInstancesActiveTimeRangeFrom);
    }

    public String getMinimumNoInstancesActiveTimeRangeTo() {
        return this.minimumNoInstancesActiveTimeRangeTo;
    }

    @DataBoundSetter
    public void setMinimumNoInstancesActiveTimeRangeTo(String minimumNoInstancesActiveTimeRangeTo) {
        MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(minimumNoInstancesActiveTimeRangeTo);
        this.minimumNoInstancesActiveTimeRangeTo = minimumNoInstancesActiveTimeRangeTo;
    }

    public LocalTime getMinimumNoInstancesActiveTimeRangeToAsTime() {
        return MinimumNumberOfInstancesTimeRangeConfig.getLocalTime(this.minimumNoInstancesActiveTimeRangeTo);
    }

    public Map<String, Boolean> getMinimumNoInstancesActiveTimeRangeDays() {
        return this.minimumNoInstancesActiveTimeRangeDays;
    }

    @DataBoundSetter
    public void setMinimumNoInstancesActiveTimeRangeDays(JSONObject minimumNoInstancesActiveTimeRangeDays) {
        this.minimumNoInstancesActiveTimeRangeDays = MinimumNumberOfInstancesTimeRangeConfig.parseDays(minimumNoInstancesActiveTimeRangeDays);
    }
}

