/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotPrice;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class SpotConfiguration
extends AbstractDescribableImpl<SpotConfiguration> {
    public final boolean useBidPrice;
    private String spotMaxBidPrice;
    private boolean fallbackToOndemand;
    private int spotBlockReservationDuration;

    @Deprecated
    public SpotConfiguration(boolean useBidPrice, String spotMaxBidPrice, boolean fallbackToOndemand, String spotBlockReservationDurationStr) {
        this.useBidPrice = useBidPrice;
        this.spotMaxBidPrice = spotMaxBidPrice;
        this.fallbackToOndemand = fallbackToOndemand;
        this.spotBlockReservationDuration = null == spotBlockReservationDurationStr || spotBlockReservationDurationStr.isEmpty() ? 0 : Integer.parseInt(spotBlockReservationDurationStr);
    }

    @DataBoundConstructor
    public SpotConfiguration(boolean useBidPrice) {
        this.useBidPrice = useBidPrice;
        this.spotMaxBidPrice = "";
    }

    public String getSpotMaxBidPrice() {
        return this.spotMaxBidPrice;
    }

    @DataBoundSetter
    public void setSpotMaxBidPrice(String spotMaxBidPrice) {
        this.spotMaxBidPrice = spotMaxBidPrice;
    }

    public boolean getFallbackToOndemand() {
        return this.fallbackToOndemand;
    }

    @DataBoundSetter
    public void setFallbackToOndemand(boolean fallbackToOndemand) {
        this.fallbackToOndemand = fallbackToOndemand;
    }

    public int getSpotBlockReservationDuration() {
        return this.spotBlockReservationDuration;
    }

    @DataBoundSetter
    public void setSpotBlockReservationDuration(int spotBlockReservationDuration) {
        this.spotBlockReservationDuration = spotBlockReservationDuration;
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SpotConfiguration config = (SpotConfiguration)((Object)obj);
        String normalizedBid = SpotConfiguration.normalizeBid(this.spotMaxBidPrice);
        String otherNormalizedBid = SpotConfiguration.normalizeBid(config.spotMaxBidPrice);
        boolean normalizedBidsAreEqual = normalizedBid == null ? otherNormalizedBid == null : normalizedBid.equals(otherNormalizedBid);
        boolean blockReservationIsEqual = true;
        if (this.spotBlockReservationDuration != config.spotBlockReservationDuration) {
            blockReservationIsEqual = false;
        }
        return this.useBidPrice == config.useBidPrice && this.fallbackToOndemand == config.fallbackToOndemand && normalizedBidsAreEqual && blockReservationIsEqual;
    }

    public int hashCode() {
        return Objects.hash(this.useBidPrice, this.spotMaxBidPrice, this.fallbackToOndemand);
    }

    public static String normalizeBid(String bid) {
        try {
            Float spotPrice = Float.valueOf(Float.parseFloat(bid));
            if ((double)spotPrice.floatValue() < 0.001) {
                return null;
            }
            return spotPrice.toString();
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SpotConfiguration> {
        public String getDisplayName() {
            return "spotConfig";
        }

        public FormValidation doCurrentSpotPrice(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String type, @QueryParameter String zone, @QueryParameter String roleArn, @QueryParameter String roleSessionName, @QueryParameter String ami) throws IOException, ServletException {
            String cp = "";
            String zoneStr = "";
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            AmazonEC2 ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region));
            if (ec2 != null) {
                try {
                    Image img;
                    DescribeSpotPriceHistoryRequest request = new DescribeSpotPriceHistoryRequest();
                    if (CloudHelper.getAvailabilityZones(ec2).contains(zone)) {
                        request.setAvailabilityZone(zone);
                        zoneStr = zone + " availability zone";
                    } else {
                        zoneStr = region + " region";
                    }
                    InstanceType ec2Type = null;
                    for (InstanceType it : InstanceType.values()) {
                        if (!it.name().equals(type)) continue;
                        ec2Type = it;
                        break;
                    }
                    if (ec2Type == null) {
                        return FormValidation.error((String)("Could not resolve instance type: " + type));
                    }
                    if (!ami.isEmpty() && (img = CloudHelper.getAmiImage(ec2, ami)) != null) {
                        ArrayList<String> productDescriptions = new ArrayList<String>();
                        productDescriptions.add(img.getPlatform() == "Windows" ? "Windows" : "Linux/UNIX");
                        request.setProductDescriptions(productDescriptions);
                    }
                    ArrayList<String> instanceType = new ArrayList<String>();
                    instanceType.add(ec2Type.toString());
                    request.setInstanceTypes(instanceType);
                    request.setStartTime(new Date());
                    DescribeSpotPriceHistoryResult result = ec2.describeSpotPriceHistory(request);
                    if (!result.getSpotPriceHistory().isEmpty()) {
                        SpotPrice currentPrice = (SpotPrice)result.getSpotPriceHistory().get(0);
                        cp = currentPrice.getSpotPrice();
                    }
                }
                catch (AmazonServiceException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            if (cp.isEmpty()) {
                return FormValidation.error((String)"Could not retrieve current Spot price");
            }
            cp = cp.substring(0, cp.length() - 3);
            return FormValidation.ok((String)("The current Spot price for a " + type + " in the " + zoneStr + " is $" + cp));
        }
    }
}

