/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

public enum ConnectionStrategy {
    PUBLIC_DNS("Public DNS"),
    PUBLIC_IP("Public IP"),
    PRIVATE_DNS("Private DNS"),
    PRIVATE_IP("Private IP");

    private final String name;

    private ConnectionStrategy(String name) {
        this.name = name;
    }

    public boolean equalsName(String other) {
        return this.name.equals(other);
    }

    public String toString() {
        return this.name;
    }

    public static ConnectionStrategy backwardsCompatible(boolean usePrivateDnsName, boolean connectUsingPublicIp, boolean associatePublicIp) {
        if (usePrivateDnsName && !connectUsingPublicIp) {
            return PRIVATE_DNS;
        }
        if (connectUsingPublicIp || associatePublicIp) {
            return PUBLIC_IP;
        }
        return PRIVATE_IP;
    }
}

