/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.Messages;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UnixData
extends AMITypeData {
    private final String rootCommandPrefix;
    private final String slaveCommandPrefix;
    private final String slaveCommandSuffix;
    private final String sshPort;

    @DataBoundConstructor
    public UnixData(String rootCommandPrefix, String slaveCommandPrefix, String slaveCommandSuffix, String sshPort) {
        this.rootCommandPrefix = rootCommandPrefix;
        this.slaveCommandPrefix = slaveCommandPrefix;
        this.slaveCommandSuffix = slaveCommandSuffix;
        this.sshPort = sshPort;
        this.readResolve();
    }

    protected Object readResolve() {
        Jenkins.get().checkPermission(Jenkins.RUN_SCRIPTS);
        return this;
    }

    @Override
    public boolean isWindows() {
        return false;
    }

    @Override
    public boolean isUnix() {
        return true;
    }

    public String getRootCommandPrefix() {
        return this.rootCommandPrefix;
    }

    public String getSlaveCommandPrefix() {
        return this.slaveCommandPrefix;
    }

    public String getSlaveCommandSuffix() {
        return this.slaveCommandSuffix;
    }

    public String getSshPort() {
        return this.sshPort == null || this.sshPort.isEmpty() ? "22" : this.sshPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootCommandPrefix == null ? 0 : this.rootCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandPrefix == null ? 0 : this.slaveCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandSuffix == null ? 0 : this.slaveCommandSuffix.hashCode());
        result = 31 * result + (this.sshPort == null ? 0 : this.sshPort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnixData other = (UnixData)((Object)obj);
        if (StringUtils.isEmpty((String)this.rootCommandPrefix) ? !StringUtils.isEmpty((String)other.rootCommandPrefix) : !this.rootCommandPrefix.equals(other.rootCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandPrefix) ? !StringUtils.isEmpty((String)other.slaveCommandPrefix) : !this.slaveCommandPrefix.equals(other.slaveCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandSuffix) ? !StringUtils.isEmpty((String)other.slaveCommandSuffix) : !this.slaveCommandSuffix.equals(other.slaveCommandSuffix)) {
            return false;
        }
        return !(StringUtils.isEmpty((String)this.sshPort) ? !StringUtils.isEmpty((String)other.sshPort) : !this.sshPort.equals(other.sshPort));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AMITypeData> {
        public String getDisplayName() {
            return "unix";
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRootCommandPrefix(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.General_MissingPermission());
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckSlaveCommandPrefix(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.General_MissingPermission());
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckSlaveCommandSuffix(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value) || Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.General_MissingPermission());
        }
    }
}

