/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.Instance;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.plugins.ec2.EC2HostAddressProvider;
import hudson.plugins.ec2.win.WinConnection;
import hudson.plugins.ec2.win.winrm.WindowsProcess;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

public class EC2WindowsLauncher
extends EC2ComputerLauncher {
    private static final String SLAVE_JAR = "slave.jar";
    final long sleepBetweenAttempts = TimeUnit.SECONDS.toMillis(10L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchScript(EC2Computer computer, TaskListener listener) throws IOException, AmazonClientException, InterruptedException {
        PrintStream logger = listener.getLogger();
        final WinConnection connection = this.connectToWinRM(computer, logger);
        EC2AbstractSlave node = computer.getNode();
        if (node == null || connection == null) {
            logger.println("Unable to fetch node information");
            return;
        }
        try {
            String initScript = node.initScript;
            String tmpDir = node.tmpDir != null && !node.tmpDir.equals("") ? node.tmpDir : "C:\\Windows\\Temp\\";
            logger.println("Creating tmp directory if it does not exist");
            connection.execute("if not exist " + tmpDir + " mkdir " + tmpDir);
            if (initScript != null && initScript.trim().length() > 0 && !connection.exists(tmpDir + ".jenkins-init")) {
                logger.println("Executing init script");
                OutputStream init = connection.putFile(tmpDir + "init.bat");
                init.write(initScript.getBytes("utf-8"));
                WindowsProcess initProcess = connection.execute("cmd /c " + tmpDir + "init.bat");
                IOUtils.copy((InputStream)initProcess.getStdout(), (OutputStream)logger);
                int exitStatus = initProcess.waitFor();
                if (exitStatus != 0) {
                    logger.println("init script failed: exit code=" + exitStatus);
                    return;
                }
                OutputStream initGuard = connection.putFile(tmpDir + ".jenkins-init");
                initGuard.write("init ran".getBytes(StandardCharsets.UTF_8));
                logger.println("init script ran successfully");
            }
            OutputStream slaveJar = connection.putFile(tmpDir + SLAVE_JAR);
            slaveJar.write(Jenkins.getInstance().getJnlpJars(SLAVE_JAR).readFully());
            logger.println("slave.jar sent remotely. Bootstrapping it");
            String jvmopts = node.jvmopts;
            final WindowsProcess process = connection.execute("java " + (jvmopts != null ? jvmopts : "") + " -jar " + tmpDir + SLAVE_JAR, 86400);
            computer.setChannel(process.getStdout(), process.getStdin(), logger, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    process.destroy();
                    connection.close();
                }
            });
        }
        catch (Throwable ioe) {
            logger.println("Ouch:");
            ioe.printStackTrace(logger);
        }
        finally {
            connection.close();
        }
    }

    private WinConnection connectToWinRM(EC2Computer computer, PrintStream logger) throws AmazonClientException, InterruptedException {
        EC2AbstractSlave node = computer.getNode();
        if (node == null) {
            return null;
        }
        long minTimeout = 3000L;
        long timeout = node.getLaunchTimeoutInMillis();
        if (timeout < 3000L) {
            timeout = 3000L;
        }
        long startTime = System.currentTimeMillis();
        logger.println(node.getDisplayName() + " booted at " + node.getCreatedTime());
        boolean alreadyBooted = startTime - node.getCreatedTime() > TimeUnit.MINUTES.toMillis(3L);
        while (true) {
            try {
                WinConnection connection;
                while (true) {
                    long waitTime;
                    if ((waitTime = System.currentTimeMillis() - startTime) > timeout) {
                        throw new AmazonClientException("Timed out after " + waitTime / 1000L + " seconds of waiting for winrm to be connected");
                    }
                    Instance instance = computer.updateInstanceDescription();
                    String host = EC2HostAddressProvider.windows(instance, computer.getSlaveTemplate().connectionStrategy).getHostText();
                    if ("0.0.0.0".equals(host)) {
                        logger.println("Invalid host 0.0.0.0, your host is most likely waiting for an ip address.");
                        throw new IOException("goto sleep");
                    }
                    logger.println("Connecting to (" + host + ") with WinRM as " + node.remoteAdmin);
                    connection = new WinConnection(host, node.remoteAdmin, node.getAdminPassword().getPlainText());
                    connection.setUseHTTPS(node.isUseHTTPS());
                    if (!connection.ping()) {
                        logger.println("Waiting for WinRM to come up. Sleeping 10s.");
                        Thread.sleep(this.sleepBetweenAttempts);
                        continue;
                    }
                    if (alreadyBooted && !node.stopOnTerminate) break;
                    logger.println("WinRM service responded. Waiting for WinRM service to stabilize on " + node.getDisplayName());
                    Thread.sleep(node.getBootDelay());
                    alreadyBooted = true;
                    logger.println("WinRM should now be ok on " + node.getDisplayName());
                    if (connection.ping()) break;
                    logger.println("WinRM not yet up. Sleeping 10s.");
                    Thread.sleep(this.sleepBetweenAttempts);
                }
                logger.println("Connected with WinRM.");
                return connection;
            }
            catch (IOException e) {
                logger.println("Waiting for WinRM to come up. Sleeping 10s.");
                Thread.sleep(this.sleepBetweenAttempts);
                continue;
            }
            break;
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

