/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import org.kohsuke.stapler.DataBoundConstructor;

public final class SpotConfiguration {
    public final boolean useBidPrice;
    public final String spotMaxBidPrice;
    public final boolean fallbackToOndemand;

    @DataBoundConstructor
    public SpotConfiguration(boolean useBidPrice, String spotMaxBidPrice, boolean fallbackToOndemand) {
        this.useBidPrice = useBidPrice;
        this.spotMaxBidPrice = spotMaxBidPrice;
        this.fallbackToOndemand = fallbackToOndemand;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpotConfiguration config = (SpotConfiguration)obj;
        String normalizedBid = SpotConfiguration.normalizeBid(this.spotMaxBidPrice);
        String otherNormalizedBid = SpotConfiguration.normalizeBid(config.spotMaxBidPrice);
        boolean normalizedBidsAreEqual = normalizedBid == null ? otherNormalizedBid == null : normalizedBid.equals(otherNormalizedBid);
        return this.useBidPrice == config.useBidPrice && this.fallbackToOndemand == config.fallbackToOndemand && normalizedBidsAreEqual;
    }

    public static String normalizeBid(String bid) {
        try {
            Float spotPrice = Float.valueOf(Float.parseFloat(bid));
            if ((double)spotPrice.floatValue() < 0.001) {
                return null;
            }
            return spotPrice.toString();
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

