/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.ResourceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.SpotPrice;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2OndemandSlave;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.SpotConfiguration;
import hudson.plugins.ec2.UnixData;
import hudson.plugins.ec2.WindowsData;
import hudson.plugins.ec2.util.DeviceMappingParser;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.slaves.iterators.api.NodeIterator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SlaveTemplate
implements Describable<SlaveTemplate> {
    private static final Logger LOGGER = Logger.getLogger(SlaveTemplate.class.getName());
    public String ami;
    public final String description;
    public final String zone;
    public final SpotConfiguration spotConfig;
    public final String securityGroups;
    public final String remoteFS;
    public final InstanceType type;
    public final boolean ebsOptimized;
    public final String labels;
    public final Node.Mode mode;
    public final String initScript;
    public final String tmpDir;
    public final String userData;
    public final String numExecutors;
    public final String remoteAdmin;
    public final String jvmopts;
    public final String subnetId;
    public final String idleTerminationMinutes;
    public final String iamInstanceProfile;
    public final boolean deleteRootOnTermination;
    public final boolean useEphemeralDevices;
    public final String customDeviceMapping;
    public int instanceCap;
    public final boolean stopOnTerminate;
    private final List<EC2Tag> tags;
    public final boolean usePrivateDnsName;
    public final boolean associatePublicIp;
    protected transient EC2Cloud parent;
    public final boolean useDedicatedTenancy;
    public transient AMITypeData amiType;
    public int launchTimeout;
    public boolean connectBySSHProcess;
    public final boolean connectUsingPublicIp;
    private boolean node = true;
    private transient Set<LabelAtom> labelSet;
    private transient Set<String> securityGroupSet;
    @Deprecated
    public transient String sshPort;
    @Deprecated
    public transient String rootCommandPrefix;
    @Deprecated
    public transient String slaveCommandPrefix;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean connectUsingPublicIp) {
        this.ami = ami;
        this.zone = zone;
        this.spotConfig = spotConfig;
        this.securityGroups = securityGroups;
        this.remoteFS = remoteFS;
        this.amiType = amiType;
        this.type = type;
        this.ebsOptimized = ebsOptimized;
        this.labels = Util.fixNull((String)labelString);
        this.mode = mode;
        this.description = description;
        this.initScript = initScript;
        this.tmpDir = tmpDir;
        this.userData = userData;
        this.numExecutors = Util.fixNull((String)numExecutors).trim();
        this.remoteAdmin = remoteAdmin;
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.subnetId = subnetId;
        this.tags = tags;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.usePrivateDnsName = usePrivateDnsName;
        this.associatePublicIp = associatePublicIp;
        this.connectUsingPublicIp = connectUsingPublicIp;
        this.useDedicatedTenancy = useDedicatedTenancy;
        this.connectBySSHProcess = connectBySSHProcess;
        this.instanceCap = null == instanceCapStr || instanceCapStr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        try {
            this.launchTimeout = Integer.parseInt(launchTimeoutStr);
        }
        catch (NumberFormatException nfe) {
            this.launchTimeout = Integer.MAX_VALUE;
        }
        this.iamInstanceProfile = iamInstanceProfile;
        this.deleteRootOnTermination = deleteRootOnTermination;
        this.useEphemeralDevices = useEphemeralDevices;
        this.customDeviceMapping = customDeviceMapping;
        this.readResolve();
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, false, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, false);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, false);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, String sshPort, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, String rootCommandPrefix, String slaveCommandPrefix, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, String launchTimeoutStr) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, new UnixData(rootCommandPrefix, slaveCommandPrefix, sshPort), jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, useEphemeralDevices, false, launchTimeoutStr, false, null);
    }

    public boolean isConnectBySSHProcess() {
        return this.connectBySSHProcess;
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getLabelString() {
        return this.labels;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getDisplayName() {
        return this.description + " (" + this.ami + ")";
    }

    String getZone() {
        return this.zone;
    }

    public String getSecurityGroupString() {
        return this.securityGroups;
    }

    public Set<String> getSecurityGroupSet() {
        return this.securityGroupSet;
    }

    public Set<String> parseSecurityGroups() {
        if (this.securityGroups == null || "".equals(this.securityGroups.trim())) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.securityGroups.split("\\s*,\\s*")));
    }

    public int getNumExecutors() {
        try {
            return Integer.parseInt(this.numExecutors);
        }
        catch (NumberFormatException e) {
            return EC2AbstractSlave.toNumExecutors(this.type);
        }
    }

    public int getSshPort() {
        try {
            String sshPort = "";
            if (this.amiType.isUnix()) {
                sshPort = ((UnixData)this.amiType).getSshPort();
            }
            return Integer.parseInt(sshPort);
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    public String getRemoteAdmin() {
        return this.remoteAdmin;
    }

    public String getRootCommandPrefix() {
        return this.amiType.isUnix() ? ((UnixData)this.amiType).getRootCommandPrefix() : "";
    }

    public String getSlaveCommandPrefix() {
        return this.amiType.isUnix() ? ((UnixData)this.amiType).getSlaveCommandPrefix() : "";
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public boolean getAssociatePublicIp() {
        return this.associatePublicIp;
    }

    public boolean isConnectUsingPublicIp() {
        return this.connectUsingPublicIp;
    }

    public List<EC2Tag> getTags() {
        if (null == this.tags) {
            return null;
        }
        return Collections.unmodifiableList(this.tags);
    }

    public String getidleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public boolean getUseDedicatedTenancy() {
        return this.useDedicatedTenancy;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public String getSpotMaxBidPrice() {
        if (this.spotConfig == null) {
            return null;
        }
        return SpotConfiguration.normalizeBid(this.spotConfig.spotMaxBidPrice);
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public void setNode(Boolean node) {
        this.node = node;
    }

    public Boolean isNode() {
        return this.node;
    }

    public EC2AbstractSlave provision(TaskListener listener, Label requiredLabel, EnumSet<ProvisionOptions> provisionOptions) throws AmazonClientException, IOException {
        if (this.spotConfig != null) {
            if (provisionOptions.contains((Object)ProvisionOptions.ALLOW_CREATE) || provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE)) {
                return this.provisionSpot(listener);
            }
            return null;
        }
        return this.provisionOndemand(listener, requiredLabel, provisionOptions);
    }

    private boolean checkInstance(PrintStream logger, Instance existingInstance, Label requiredLabel, EC2AbstractSlave[] returnNode) {
        SlaveTemplate.logProvision(logger, "checkInstance: " + existingInstance);
        if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
            if (existingInstance.getIamInstanceProfile() != null) {
                if (!existingInstance.getIamInstanceProfile().getArn().equals(this.getIamInstanceProfile())) {
                    SlaveTemplate.logProvision(logger, " false - IAM Instance profile does not match");
                    return false;
                }
            } else {
                SlaveTemplate.logProvision(logger, " false - Null IAM Instance profile");
                return false;
            }
        }
        if (existingInstance.getState().getName().equalsIgnoreCase(InstanceStateName.Terminated.toString()) || existingInstance.getState().getName().equalsIgnoreCase(InstanceStateName.ShuttingDown.toString())) {
            SlaveTemplate.logProvision(logger, " false - Instance is terminated or shutting down");
            return false;
        }
        for (EC2AbstractSlave node : NodeIterator.nodes(EC2AbstractSlave.class)) {
            if (!node.getInstanceId().equals(existingInstance.getInstanceId())) continue;
            SlaveTemplate.logProvision(logger, "Found existing corresponding Jenkins slave: " + node.getInstanceId());
            if (!node.toComputer().isPartiallyIdle()) {
                SlaveTemplate.logProvision(logger, " false - Node is not partially idle");
                return false;
            }
            if (requiredLabel != null && !requiredLabel.matches((Collection)node.getAssignedLabels())) {
                SlaveTemplate.logProvision(logger, " false - we need a Node having label " + requiredLabel);
                return false;
            }
            SlaveTemplate.logProvision(logger, " true - Node has capacity - can use it");
            returnNode[0] = node;
            return true;
        }
        SlaveTemplate.logProvision(logger, " true - Instance has no node, but can be used");
        return true;
    }

    private static void logProvision(PrintStream logger, String message) {
        logger.println(message);
        LOGGER.fine(message);
    }

    private static void logProvisionInfo(PrintStream logger, String message) {
        logger.println(message);
        LOGGER.info(message);
    }

    private EC2AbstractSlave provisionOndemand(TaskListener listener, Label requiredLabel, EnumSet<ProvisionOptions> provisionOptions) throws AmazonClientException, IOException {
        PrintStream logger = listener.getLogger();
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            SlaveTemplate.logProvisionInfo(logger, "Considering launching " + this.ami + " for template " + this.description);
            KeyPair keyPair = this.getKeyPair(ec2);
            RunInstancesRequest riRequest = new RunInstancesRequest(this.ami, Integer.valueOf(1), Integer.valueOf(1));
            InstanceNetworkInterfaceSpecification net = new InstanceNetworkInterfaceSpecification();
            riRequest.setEbsOptimized(Boolean.valueOf(this.ebsOptimized));
            this.setupRootDevice(riRequest.getBlockDeviceMappings());
            if (this.useEphemeralDevices) {
                this.setupEphemeralDeviceMapping(riRequest.getBlockDeviceMappings());
            } else {
                this.setupCustomDeviceMapping(riRequest.getBlockDeviceMappings());
            }
            if (this.stopOnTerminate) {
                riRequest.setInstanceInitiatedShutdownBehavior(ShutdownBehavior.Stop);
                SlaveTemplate.logProvisionInfo(logger, "Setting Instance Initiated Shutdown Behavior : ShutdownBehavior.Stop");
            } else {
                riRequest.setInstanceInitiatedShutdownBehavior(ShutdownBehavior.Terminate);
                SlaveTemplate.logProvisionInfo(logger, "Setting Instance Initiated Shutdown Behavior : ShutdownBehavior.Terminate");
            }
            ArrayList<Filter> diFilters = new ArrayList<Filter>();
            diFilters.add(new Filter("image-id").withValues(new String[]{this.ami}));
            if (StringUtils.isNotBlank((String)this.getZone())) {
                Placement placement = new Placement(this.getZone());
                if (this.getUseDedicatedTenancy()) {
                    placement.setTenancy("dedicated");
                }
                riRequest.setPlacement(placement);
                diFilters.add(new Filter("availability-zone").withValues(new String[]{this.getZone()}));
            }
            if (StringUtils.isNotBlank((String)this.getSubnetId())) {
                List<String> groupIds;
                if (this.getAssociatePublicIp()) {
                    net.setSubnetId(this.getSubnetId());
                } else {
                    riRequest.setSubnetId(this.getSubnetId());
                }
                diFilters.add(new Filter("subnet-id").withValues(new String[]{this.getSubnetId()}));
                if (!this.securityGroupSet.isEmpty() && !(groupIds = this.getEc2SecurityGroups(ec2)).isEmpty()) {
                    if (this.getAssociatePublicIp()) {
                        net.setGroups(groupIds);
                    } else {
                        riRequest.setSecurityGroupIds(groupIds);
                    }
                    diFilters.add(new Filter("instance.group-id").withValues(groupIds));
                }
            } else {
                riRequest.setSecurityGroups(this.securityGroupSet);
                if (!this.securityGroupSet.isEmpty()) {
                    diFilters.add(new Filter("instance.group-name").withValues(this.securityGroupSet));
                }
            }
            String userDataString = Base64.encodeBase64String((byte[])this.userData.getBytes(StandardCharsets.UTF_8));
            riRequest.setUserData(userDataString);
            riRequest.setKeyName(keyPair.getKeyName());
            diFilters.add(new Filter("key-name").withValues(new String[]{keyPair.getKeyName()}));
            riRequest.setInstanceType(this.type.toString());
            diFilters.add(new Filter("instance-type").withValues(new String[]{this.type.toString()}));
            if (this.getAssociatePublicIp()) {
                net.setAssociatePublicIpAddress(Boolean.valueOf(true));
                net.setDeviceIndex(Integer.valueOf(0));
                riRequest.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{net});
            }
            boolean hasCustomTypeTag = false;
            HashSet<Tag> instTags = null;
            if (this.tags != null && !this.tags.isEmpty()) {
                instTags = new HashSet<Tag>();
                for (EC2Tag t : this.tags) {
                    instTags.add(new Tag(t.getName(), t.getValue()));
                    diFilters.add(new Filter("tag:" + t.getName()).withValues(new String[]{t.getValue()}));
                    if (!StringUtils.equals((String)t.getName(), (String)"jenkins_slave_type")) continue;
                    hasCustomTypeTag = true;
                }
            }
            if (!hasCustomTypeTag) {
                if (instTags == null) {
                    instTags = new HashSet();
                }
                instTags.add(new Tag("jenkins_slave_type", EC2Cloud.getSlaveTypeTagValue("demand", this.description)));
            }
            DescribeInstancesRequest diRequest = new DescribeInstancesRequest();
            diRequest.setFilters(diFilters);
            SlaveTemplate.logProvision(logger, "Looking for existing instances with describe-instance: " + diRequest);
            DescribeInstancesResult diResult = ec2.describeInstances(diRequest);
            EC2AbstractSlave[] ec2Node = new EC2AbstractSlave[1];
            Instance existingInstance = null;
            if (!provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE)) {
                block3: for (Reservation reservation : diResult.getReservations()) {
                    for (Instance instance : reservation.getInstances()) {
                        if (!this.checkInstance(logger, instance, requiredLabel, ec2Node)) continue;
                        existingInstance = instance;
                        SlaveTemplate.logProvision(logger, "Found existing instance: " + existingInstance + (ec2Node[0] != null ? " node: " + ec2Node[0].getInstanceId() : ""));
                        break block3;
                    }
                }
            }
            if (existingInstance == null) {
                if (!provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE) && !provisionOptions.contains((Object)ProvisionOptions.ALLOW_CREATE)) {
                    SlaveTemplate.logProvision(logger, "No existing instance found - but cannot create new instance");
                    return null;
                }
                if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
                    riRequest.setIamInstanceProfile(new IamInstanceProfileSpecification().withArn(this.getIamInstanceProfile()));
                }
                if (instTags != null) {
                    TagSpecification tagSpecification = new TagSpecification();
                    tagSpecification.setResourceType(ResourceType.Instance);
                    tagSpecification.setTags(instTags);
                    Set<TagSpecification> tagSpecifications = Collections.singleton(tagSpecification);
                    riRequest.setTagSpecifications(tagSpecifications);
                }
                Instance inst = (Instance)ec2.runInstances(riRequest).getReservation().getInstances().get(0);
                SlaveTemplate.logProvisionInfo(logger, "No existing instance found - created new instance: " + inst);
                return this.newOndemandSlave(inst);
            }
            if (existingInstance.getState().getName().equalsIgnoreCase(InstanceStateName.Stopping.toString()) || existingInstance.getState().getName().equalsIgnoreCase(InstanceStateName.Stopped.toString())) {
                ArrayList<String> instances = new ArrayList<String>();
                instances.add(existingInstance.getInstanceId());
                StartInstancesRequest siRequest = new StartInstancesRequest(instances);
                StartInstancesResult siResult = ec2.startInstances(siRequest);
                SlaveTemplate.logProvisionInfo(logger, "Found stopped instance - starting it: " + existingInstance + " result:" + siResult);
            } else {
                SlaveTemplate.logProvisionInfo(logger, "Found existing pending or running: " + existingInstance.getState().getName() + " instance: " + existingInstance);
            }
            if (ec2Node[0] != null) {
                SlaveTemplate.logProvisionInfo(logger, "Using existing slave: " + ec2Node[0].getInstanceId());
                return ec2Node[0];
            }
            SlaveTemplate.logProvision(logger, "Creating new slave for existing instance: " + existingInstance);
            return this.newOndemandSlave(existingInstance);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void setupRootDevice(List<BlockDeviceMapping> deviceMappings) {
        if (this.deleteRootOnTermination && this.getImage().getRootDeviceType().equals("ebs")) {
            List<BlockDeviceMapping> rootDeviceMappings = this.getAmiBlockDeviceMappings();
            BlockDeviceMapping rootMapping = null;
            Iterator<BlockDeviceMapping> iterator = rootDeviceMappings.iterator();
            if (iterator.hasNext()) {
                BlockDeviceMapping deviceMapping = iterator.next();
                System.out.println("AMI had " + deviceMapping.getDeviceName());
                System.out.println(deviceMapping.getEbs());
                rootMapping = deviceMapping;
            }
            for (BlockDeviceMapping mapping : deviceMappings) {
                System.out.println("Request had " + mapping.getDeviceName());
                if (!rootMapping.getDeviceName().equals(mapping.getDeviceName())) continue;
                mapping.getEbs().setDeleteOnTermination(Boolean.TRUE);
                return;
            }
            BlockDeviceMapping newMapping = new BlockDeviceMapping().withDeviceName(rootMapping.getDeviceName());
            EbsBlockDevice newEbs = new EbsBlockDevice();
            newEbs.setDeleteOnTermination(Boolean.TRUE);
            newMapping.setEbs(newEbs);
            deviceMappings.add(0, newMapping);
        }
    }

    private List<BlockDeviceMapping> getNewEphemeralDeviceMapping() {
        List<BlockDeviceMapping> oldDeviceMapping = this.getAmiBlockDeviceMappings();
        HashSet<String> occupiedDevices = new HashSet<String>();
        for (BlockDeviceMapping mapping : oldDeviceMapping) {
            occupiedDevices.add(mapping.getDeviceName());
        }
        ArrayList<String> available = new ArrayList<String>(Arrays.asList("ephemeral0", "ephemeral1", "ephemeral2", "ephemeral3"));
        ArrayList<BlockDeviceMapping> newDeviceMapping = new ArrayList<BlockDeviceMapping>(4);
        for (char suffix = 'b'; suffix <= 'z' && !available.isEmpty(); suffix = (char)(suffix + '\u0001')) {
            String deviceName = String.format("/dev/xvd%s", Character.valueOf(suffix));
            if (occupiedDevices.contains(deviceName)) continue;
            BlockDeviceMapping newMapping = new BlockDeviceMapping().withDeviceName(deviceName).withVirtualName((String)available.get(0));
            newDeviceMapping.add(newMapping);
            available.remove(0);
        }
        return newDeviceMapping;
    }

    private void setupEphemeralDeviceMapping(List<BlockDeviceMapping> deviceMappings) {
        deviceMappings.addAll(this.getNewEphemeralDeviceMapping());
    }

    private List<BlockDeviceMapping> getAmiBlockDeviceMappings() {
        return this.getImage().getBlockDeviceMappings();
    }

    private Image getImage() {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(new String[]{this.ami});
        for (Image image : this.getParent().connect().describeImages(request).getImages()) {
            if (!this.ami.equals(image.getImageId())) continue;
            return image;
        }
        throw new AmazonClientException("Unable to find AMI " + this.ami);
    }

    private void setupCustomDeviceMapping(List<BlockDeviceMapping> deviceMappings) {
        if (StringUtils.isNotBlank((String)this.customDeviceMapping)) {
            deviceMappings.addAll(DeviceMappingParser.parse(this.customDeviceMapping));
        }
    }

    private EC2AbstractSlave provisionSpot(TaskListener listener) throws AmazonClientException, IOException {
        PrintStream logger = listener.getLogger();
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            logger.println("Launching " + this.ami + " for template " + this.description);
            LOGGER.info("Launching " + this.ami + " for template " + this.description);
            KeyPair keyPair = this.getKeyPair(ec2);
            RequestSpotInstancesRequest spotRequest = new RequestSpotInstancesRequest();
            if (this.getSpotMaxBidPrice() == null) {
                throw new AmazonClientException("Invalid Spot price specified: " + this.getSpotMaxBidPrice());
            }
            spotRequest.setSpotPrice(this.getSpotMaxBidPrice());
            spotRequest.setInstanceCount(Integer.valueOf(1));
            LaunchSpecification launchSpecification = new LaunchSpecification();
            InstanceNetworkInterfaceSpecification net = new InstanceNetworkInterfaceSpecification();
            launchSpecification.setImageId(this.ami);
            launchSpecification.setInstanceType(this.type);
            launchSpecification.setEbsOptimized(Boolean.valueOf(this.ebsOptimized));
            if (StringUtils.isNotBlank((String)this.getZone())) {
                SpotPlacement placement = new SpotPlacement(this.getZone());
                launchSpecification.setPlacement(placement);
            }
            if (StringUtils.isNotBlank((String)this.getSubnetId())) {
                List<String> groupIds;
                if (this.getAssociatePublicIp()) {
                    net.setSubnetId(this.getSubnetId());
                } else {
                    launchSpecification.setSubnetId(this.getSubnetId());
                }
                if (!this.securityGroupSet.isEmpty() && !(groupIds = this.getEc2SecurityGroups(ec2)).isEmpty()) {
                    if (this.getAssociatePublicIp()) {
                        net.setGroups(groupIds);
                    } else {
                        ArrayList<GroupIdentifier> groups = new ArrayList<GroupIdentifier>();
                        for (String string : groupIds) {
                            GroupIdentifier group = new GroupIdentifier();
                            group.setGroupId(string);
                            groups.add(group);
                        }
                        if (!groups.isEmpty()) {
                            launchSpecification.setAllSecurityGroups(groups);
                        }
                    }
                }
            } else if (!this.securityGroupSet.isEmpty()) {
                launchSpecification.setSecurityGroups(this.securityGroupSet);
            }
            String userDataString = Base64.encodeBase64String((byte[])this.userData.getBytes(StandardCharsets.UTF_8));
            launchSpecification.setUserData(userDataString);
            launchSpecification.setKeyName(keyPair.getKeyName());
            launchSpecification.setInstanceType(this.type.toString());
            if (this.getAssociatePublicIp()) {
                net.setAssociatePublicIpAddress(Boolean.valueOf(true));
                net.setDeviceIndex(Integer.valueOf(0));
                launchSpecification.withNetworkInterfaces(new InstanceNetworkInterfaceSpecification[]{net});
            }
            boolean hasCustomTypeTag = false;
            HashSet<Tag> instTags = null;
            if (this.tags != null && !this.tags.isEmpty()) {
                instTags = new HashSet<Tag>();
                for (EC2Tag t : this.tags) {
                    instTags.add(new Tag(t.getName(), t.getValue()));
                    if (!StringUtils.equals((String)t.getName(), (String)"jenkins_slave_type")) continue;
                    hasCustomTypeTag = true;
                }
            }
            if (!hasCustomTypeTag) {
                if (instTags == null) {
                    instTags = new HashSet();
                }
                instTags.add(new Tag("jenkins_slave_type", EC2Cloud.getSlaveTypeTagValue("spot", this.description)));
            }
            if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
                launchSpecification.setIamInstanceProfile(new IamInstanceProfileSpecification().withArn(this.getIamInstanceProfile()));
            }
            this.setupRootDevice(launchSpecification.getBlockDeviceMappings());
            if (this.useEphemeralDevices) {
                this.setupEphemeralDeviceMapping(launchSpecification.getBlockDeviceMappings());
            } else {
                this.setupCustomDeviceMapping(launchSpecification.getBlockDeviceMappings());
            }
            spotRequest.setLaunchSpecification(launchSpecification);
            RequestSpotInstancesResult requestSpotInstancesResult = ec2.requestSpotInstances(spotRequest);
            List reqInstances = requestSpotInstancesResult.getSpotInstanceRequests();
            if (reqInstances.isEmpty()) {
                throw new AmazonClientException("No spot instances found");
            }
            SpotInstanceRequest spotInstReq = (SpotInstanceRequest)reqInstances.get(0);
            if (spotInstReq == null) {
                throw new AmazonClientException("Spot instance request is null");
            }
            String slaveName = spotInstReq.getSpotInstanceRequestId();
            if (instTags != null) {
                this.updateRemoteTags(ec2, instTags, "InvalidSpotInstanceRequestID.NotFound", spotInstReq.getSpotInstanceRequestId());
                spotInstReq.setTags(instTags);
            }
            logger.println("Spot instance id in provision: " + spotInstReq.getSpotInstanceRequestId());
            LOGGER.info("Spot instance id in provision: " + spotInstReq.getSpotInstanceRequestId());
            return this.newSpotSlave(spotInstReq, slaveName);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected EC2OndemandSlave newOndemandSlave(Instance inst) throws Descriptor.FormException, IOException {
        return new EC2OndemandSlave(inst.getInstanceId(), this.description, this.remoteFS, this.getNumExecutors(), this.labels, this.mode, this.initScript, this.tmpDir, this.remoteAdmin, this.jvmopts, this.stopOnTerminate, this.idleTerminationMinutes, inst.getPublicDnsName(), inst.getPrivateDnsName(), EC2Tag.fromAmazonTags(inst.getTags()), this.parent.name, this.usePrivateDnsName, this.useDedicatedTenancy, this.getLaunchTimeout(), this.amiType);
    }

    protected EC2SpotSlave newSpotSlave(SpotInstanceRequest sir, String name) throws Descriptor.FormException, IOException {
        return new EC2SpotSlave(name, sir.getSpotInstanceRequestId(), this.description, this.remoteFS, this.getNumExecutors(), this.mode, this.initScript, this.tmpDir, this.labels, this.remoteAdmin, this.jvmopts, this.idleTerminationMinutes, EC2Tag.fromAmazonTags(sir.getTags()), this.parent.name, this.usePrivateDnsName, this.getLaunchTimeout(), this.amiType);
    }

    private KeyPair getKeyPair(AmazonEC2 ec2) throws IOException, AmazonClientException {
        KeyPair keyPair = this.parent.getPrivateKey().find(ec2);
        if (keyPair == null) {
            throw new AmazonClientException("No matching keypair found on EC2. Is the EC2 private key a valid one?");
        }
        return keyPair;
    }

    private void updateRemoteTags(AmazonEC2 ec2, Collection<Tag> instTags, String catchErrorCode, String ... params) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            try {
                CreateTagsRequest tagRequest = new CreateTagsRequest();
                tagRequest.withResources(params).setTags(instTags);
                ec2.createTags(tagRequest);
                break;
            }
            catch (AmazonServiceException e) {
                if (e.getErrorCode().equals(catchErrorCode)) {
                    Thread.sleep(5000L);
                    continue;
                }
                LOGGER.log(Level.SEVERE, e.getErrorMessage(), e);
                continue;
            }
        }
    }

    private List<String> getEc2SecurityGroups(AmazonEC2 ec2) throws AmazonClientException {
        ArrayList<String> groupIds = new ArrayList<String>();
        DescribeSecurityGroupsResult groupResult = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2);
        if (groupResult.getSecurityGroups().size() == 0) {
            groupResult = this.getSecurityGroupsBy("group-id", this.securityGroupSet, ec2);
        }
        for (SecurityGroup group : groupResult.getSecurityGroups()) {
            if (group.getVpcId() == null || group.getVpcId().isEmpty()) continue;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            filters.add(new Filter("vpc-id").withValues(new String[]{group.getVpcId()}));
            filters.add(new Filter("state").withValues(new String[]{"available"}));
            filters.add(new Filter("subnet-id").withValues(new String[]{this.getSubnetId()}));
            DescribeSubnetsRequest subnetReq = new DescribeSubnetsRequest();
            subnetReq.withFilters(filters);
            DescribeSubnetsResult subnetResult = ec2.describeSubnets(subnetReq);
            List subnets = subnetResult.getSubnets();
            if (subnets == null || subnets.isEmpty()) continue;
            groupIds.add(group.getGroupId());
        }
        if (this.securityGroupSet.size() != groupIds.size()) {
            throw new AmazonClientException("Security groups must all be VPC security groups to work in a VPC context");
        }
        return groupIds;
    }

    private DescribeSecurityGroupsResult getSecurityGroupsBy(String filterName, Set<String> filterValues, AmazonEC2 ec2) {
        DescribeSecurityGroupsRequest groupReq = new DescribeSecurityGroupsRequest();
        groupReq.withFilters(new Filter[]{new Filter(filterName).withValues(filterValues)});
        return ec2.describeSecurityGroups(groupReq);
    }

    public EC2AbstractSlave attach(String instanceId, TaskListener listener) throws AmazonClientException, IOException {
        PrintStream logger = listener.getLogger();
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            LOGGER.info("Attaching to " + instanceId);
            DescribeInstancesRequest request = new DescribeInstancesRequest();
            request.setInstanceIds(Collections.singletonList(instanceId));
            Instance inst = (Instance)((Reservation)ec2.describeInstances(request).getReservations().get(0)).getInstances().get(0);
            return this.newOndemandSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labels);
        this.securityGroupSet = this.parseSecurityGroups();
        if (this.instanceCap == 0) {
            this.instanceCap = Integer.MAX_VALUE;
        }
        if (this.amiType == null) {
            this.amiType = new UnixData(this.rootCommandPrefix, this.slaveCommandPrefix, this.sshPort);
        }
        return this;
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public int getLaunchTimeout() {
        return this.launchTimeout <= 0 ? Integer.MAX_VALUE : this.launchTimeout;
    }

    public String getLaunchTimeoutStr() {
        if (this.launchTimeout == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.launchTimeout);
    }

    public boolean isWindowsSlave() {
        return this.amiType.isWindows();
    }

    public boolean isUnixSlave() {
        return this.amiType.isUnix();
    }

    public Secret getAdminPassword() {
        return this.amiType.isWindows() ? ((WindowsData)this.amiType).getPassword() : Secret.fromString((String)"");
    }

    public boolean isUseHTTPS() {
        return this.amiType.isWindows() && ((WindowsData)this.amiType).isUseHTTPS();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SlaveTemplate> {
        public String getDisplayName() {
            return null;
        }

        public List<Descriptor<AMITypeData>> getAMITypeDescriptors() {
            return Jenkins.getInstance().getDescriptorList(AMITypeData.class);
        }

        public String getHelpFile(String fieldName) {
            String p = super.getHelpFile(fieldName);
            if (p == null) {
                p = Jenkins.getInstance().getDescriptor(EC2OndemandSlave.class).getHelpFile(fieldName);
            }
            if (p == null) {
                p = Jenkins.getInstance().getDescriptor(EC2SpotSlave.class).getHelpFile(fieldName);
            }
            return p;
        }

        public FormValidation doValidateAmi(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String ec2endpoint, @QueryParameter String region, @QueryParameter String ami) throws IOException {
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
            AmazonEC2 ec2 = region != null ? EC2Cloud.connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region)) : EC2Cloud.connect(credentialsProvider, new URL(ec2endpoint));
            if (ec2 != null) {
                try {
                    LinkedList<String> images = new LinkedList<String>();
                    images.add(ami);
                    LinkedList owners = new LinkedList();
                    LinkedList users = new LinkedList();
                    DescribeImagesRequest request = new DescribeImagesRequest();
                    request.setImageIds(images);
                    request.setOwners(owners);
                    request.setExecutableUsers(users);
                    List img = ec2.describeImages(request).getImages();
                    if (img == null || img.isEmpty()) {
                        return FormValidation.error((String)("No such AMI, or not usable with this accessId: " + ami));
                    }
                    String ownerAlias = ((Image)img.get(0)).getImageOwnerAlias();
                    return FormValidation.ok((String)(((Image)img.get(0)).getImageLocation() + (ownerAlias != null ? " by " + ownerAlias : "")));
                }
                catch (AmazonClientException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLabelString(@QueryParameter String value, @QueryParameter Node.Mode mode) {
            if (mode == Node.Mode.EXCLUSIVE && (value == null || value.trim().isEmpty())) {
                return FormValidation.warning((String)"You may want to assign labels to this node; it's marked to only run jobs that are exclusively tied to itself or a label.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIdleTerminationMinutes(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= -59) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Idle Termination time must be a greater than -59 (or null)");
        }

        public FormValidation doCheckInstanceCapStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val > 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"InstanceCap must be a non-negative integer (or null)");
        }

        public FormValidation doCheckLaunchTimeoutStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Launch Timeout must be a non-negative integer (or null)");
        }

        public ListBoxModel doFillZoneItems(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region) throws IOException, ServletException {
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
            return EC2AbstractSlave.fillZoneItems(credentialsProvider, region);
        }

        public FormValidation doCheckSpotMaxBidPrice(@QueryParameter String spotMaxBidPrice) {
            if (SpotConfiguration.normalizeBid(spotMaxBidPrice) != null) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Not a correct bid price");
        }

        private ArrayList<String> getAvailabilityZones(AmazonEC2 ec2) {
            ArrayList<String> availabilityZones = new ArrayList<String>();
            DescribeAvailabilityZonesResult zones = ec2.describeAvailabilityZones();
            List zoneList = zones.getAvailabilityZones();
            for (AvailabilityZone z : zoneList) {
                availabilityZones.add(z.getZoneName());
            }
            return availabilityZones;
        }

        public FormValidation doCurrentSpotPrice(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String type, @QueryParameter String zone) throws IOException, ServletException {
            String cp = "";
            String zoneStr = "";
            AWSCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
            AmazonEC2 ec2 = EC2Cloud.connect(credentialsProvider, AmazonEC2Cloud.getEc2EndpointUrl(region));
            if (ec2 != null) {
                try {
                    DescribeSpotPriceHistoryRequest request = new DescribeSpotPriceHistoryRequest();
                    if (this.getAvailabilityZones(ec2).contains(zone)) {
                        request.setAvailabilityZone(zone);
                        zoneStr = zone + " availability zone";
                    } else {
                        zoneStr = region + " region";
                    }
                    InstanceType ec2Type = null;
                    for (InstanceType it : InstanceType.values()) {
                        if (!it.name().equals(type)) continue;
                        ec2Type = it;
                        break;
                    }
                    if (ec2Type == null) {
                        return FormValidation.error((String)("Could not resolve instance type: " + type));
                    }
                    ArrayList<String> instanceType = new ArrayList<String>();
                    instanceType.add(ec2Type.toString());
                    request.setInstanceTypes(instanceType);
                    request.setStartTime(new Date());
                    DescribeSpotPriceHistoryResult result = ec2.describeSpotPriceHistory(request);
                    if (!result.getSpotPriceHistory().isEmpty()) {
                        SpotPrice currentPrice = (SpotPrice)result.getSpotPriceHistory().get(0);
                        cp = currentPrice.getSpotPrice();
                    }
                }
                catch (AmazonServiceException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            if (cp.isEmpty()) {
                return FormValidation.error((String)"Could not retrieve current Spot price");
            }
            cp = cp.substring(0, cp.length() - 3);
            return FormValidation.ok((String)("The current Spot price for a " + type + " in the " + zoneStr + " is $" + cp));
        }
    }

    public static enum ProvisionOptions {
        ALLOW_CREATE,
        FORCE_CREATE;

    }
}

