/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotInstanceState;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2RetentionStrategy;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.ssh.EC2UnixLauncher;
import hudson.plugins.ec2.win.EC2WindowsLauncher;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public final class EC2SpotSlave
extends EC2AbstractSlave {
    private static final Logger LOGGER = Logger.getLogger(EC2SpotSlave.class.getName());
    private final String spotInstanceRequestId;

    public EC2SpotSlave(String name, String spotInstanceRequestId, String description, String remoteFS, int numExecutors, Node.Mode mode, String initScript, String tmpDir, String labelString, String remoteAdmin, String jvmopts, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean usePrivateDnsName, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        this(description + " (" + name + ")", spotInstanceRequestId, description, remoteFS, numExecutors, mode, initScript, tmpDir, labelString, Collections.emptyList(), remoteAdmin, jvmopts, idleTerminationMinutes, tags, cloudName, usePrivateDnsName, launchTimeout, amiType);
    }

    @DataBoundConstructor
    public EC2SpotSlave(String name, String spotInstanceRequestId, String description, String remoteFS, int numExecutors, Node.Mode mode, String initScript, String tmpDir, String labelString, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean usePrivateDnsName, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        super(name, "", description, remoteFS, numExecutors, mode, labelString, amiType.isWindows() ? new EC2WindowsLauncher() : new EC2UnixLauncher(), new EC2RetentionStrategy(idleTerminationMinutes), initScript, tmpDir, nodeProperties, remoteAdmin, jvmopts, false, idleTerminationMinutes, tags, cloudName, usePrivateDnsName, false, launchTimeout, amiType);
        this.name = name;
        this.spotInstanceRequestId = spotInstanceRequestId;
    }

    @Override
    protected boolean isAlive(boolean force) {
        return super.isAlive(force) || !this.isSpotRequestDead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        block15: {
            try {
                AmazonEC2 ec2 = this.getCloud().connect();
                String instanceId = this.getInstanceId();
                List<String> requestIds = Collections.singletonList(this.spotInstanceRequestId);
                CancelSpotInstanceRequestsRequest cancelRequest = new CancelSpotInstanceRequestsRequest(requestIds);
                try {
                    ec2.cancelSpotInstanceRequests(cancelRequest);
                    LOGGER.info("Canceled Spot request: " + this.spotInstanceRequestId);
                    if (instanceId == null || instanceId.equals("")) break block15;
                    if (!super.isAlive(true)) {
                        LOGGER.info("EC2 instance already terminated: " + instanceId);
                        break block15;
                    }
                    TerminateInstancesRequest request = new TerminateInstancesRequest(Collections.singletonList(instanceId));
                    ec2.terminateInstances(request);
                    LOGGER.info("Terminated EC2 instance (terminated): " + instanceId);
                }
                catch (AmazonServiceException e) {
                    LOGGER.log(Level.WARNING, "Failed to terminated instance and cancel Spot request: " + this.spotInstanceRequestId, e);
                }
                catch (AmazonClientException e) {
                    LOGGER.log(Level.WARNING, "Failed to terminated instance and cancel Spot request: " + this.spotInstanceRequestId, e);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to remove slave: ", e);
            }
            finally {
                try {
                    Jenkins.getInstance().removeNode((Node)this);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to remove slave: " + this.name, e);
                }
            }
        }
    }

    SpotInstanceRequest getSpotRequest() {
        AmazonEC2 ec2 = this.getCloud().connect();
        DescribeSpotInstanceRequestsRequest dsirRequest = new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(new String[]{this.spotInstanceRequestId});
        DescribeSpotInstanceRequestsResult dsirResult = null;
        List siRequests = null;
        try {
            dsirResult = ec2.describeSpotInstanceRequests(dsirRequest);
            siRequests = dsirResult.getSpotInstanceRequests();
        }
        catch (AmazonServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to fetch spot instance request for requestId: " + this.spotInstanceRequestId);
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to fetch spot instance request for requestId: " + this.spotInstanceRequestId);
        }
        if (dsirResult == null || siRequests.isEmpty()) {
            return null;
        }
        return (SpotInstanceRequest)siRequests.get(0);
    }

    public boolean isSpotRequestDead() {
        SpotInstanceState requestState = SpotInstanceState.fromValue((String)this.getSpotRequest().getState());
        return requestState == SpotInstanceState.Cancelled || requestState == SpotInstanceState.Closed || requestState == SpotInstanceState.Failed;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    @Override
    public String getInstanceId() {
        SpotInstanceRequest sr;
        if ((this.instanceId == null || this.instanceId.equals("")) && (sr = this.getSpotRequest()) != null) {
            this.instanceId = sr.getInstanceId();
        }
        return this.instanceId;
    }

    @Override
    public void onConnected() {
        this.pushLiveInstancedata();
    }

    @Override
    public String getEc2Type() {
        String spotMaxBidPrice = this.getSpotRequest().getSpotPrice();
        return Messages.EC2SpotSlave_Spot1() + spotMaxBidPrice.substring(0, spotMaxBidPrice.length() - 3) + Messages.EC2SpotSlave_Spot2();
    }

    @Extension
    public static final class DescriptorImpl
    extends EC2AbstractSlave.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return Messages.EC2SpotSlave_AmazonEC2SpotInstance();
        }
    }
}

