/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import de.codecentric.jenkins.dashboard.DashboardView;
import de.codecentric.jenkins.dashboard.persistence.converter.DateTimeConverter;
import de.codecentric.jenkins.dashboard.persistence.xmlwrapper.ServerInstances;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class XStreamHelper {
    private static final Logger LOGGER = Logger.getLogger(DashboardView.class.getName());
    private static XStreamHelper instance;
    private final File f;
    private final String filename = "deploymentdashboard.xml";
    private XStream xStream;
    private String filePath;

    private XStreamHelper() {
        String jenkinsHome = Jenkins.getInstance().getRootDir().getAbsolutePath();
        this.filePath = jenkinsHome + "/plugins/jenkins-deployment-dashboard";
        this.filePath = this.filePath + "/" + "deploymentdashboard.xml";
        this.f = new File(this.filePath);
        if (!this.f.exists()) {
            try {
                this.f.getParentFile().mkdirs();
                this.f.createNewFile();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Could not create file {} for configuration.", this.f.getPath());
            }
        }
    }

    public static XStreamHelper getInstance() {
        if (instance == null) {
            instance = new XStreamHelper();
        }
        return instance;
    }

    private void writeXML(Object o) {
        try {
            FileOutputStream fos = new FileOutputStream(this.f);
            this.xStream.toXML(o, (OutputStream)fos);
            fos.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Could not write object to configuration file.");
        }
    }

    private Object readXML() {
        Object o = null;
        try {
            FileInputStream fis = new FileInputStream(this.f);
            o = this.xStream.fromXML((InputStream)fis);
            fis.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Could not read object from configuration file.");
        }
        return o;
    }

    private void prepareXStreamForServerInstances() {
        this.xStream = new XStream();
        this.xStream.registerConverter((Converter)new DateTimeConverter());
        this.xStream.processAnnotations(new Class[]{ServerInstances.class, ServerInstances.class});
    }

    public void toXML(ServerInstances instances) {
        this.prepareXStreamForServerInstances();
        this.writeXML(instances);
    }

    public ServerInstances serverInstancesfromXML() {
        this.prepareXStreamForServerInstances();
        return (ServerInstances)this.readXML();
    }
}

