/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard.impl.repositories.artifactory;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import de.codecentric.jenkins.dashboard.api.repositories.Artifact;
import de.codecentric.jenkins.dashboard.api.repositories.RepositoryInterface;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.ArtifactoryClient;
import org.jfrog.artifactory.client.model.RepoPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ArtifactoryConnector
implements RepositoryInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryConnector.class);
    private String username;
    private String password;
    private URI repositoryURI;

    public ArtifactoryConnector(String username, String password, URI repositoryURI) {
        LOGGER.info("ArtifactoryConnector");
        this.username = username;
        this.password = password;
        this.repositoryURI = repositoryURI;
    }

    @Override
    public boolean canConnect() {
        LOGGER.info("Checking Artifactory connection");
        ClientResponse response = this.getResponse();
        return this.canConnect(response);
    }

    protected boolean canConnect(ClientResponse response) {
        int status = response.getStatus();
        if (status == 200) {
            LOGGER.info("Connection ok");
            return true;
        }
        LOGGER.error("Could not connect to {}. ResponseCode: {}", (Object)this.repositoryURI, (Object)status);
        return false;
    }

    @Override
    public List<Artifact> getArtefactList(String artifactId) {
        return this.getArtefactList("", artifactId);
    }

    @Override
    public List<Artifact> getArtefactList(String groupId, String artifactId) {
        LOGGER.info("Getting Artefact List from Server [" + this.repositoryURI + "] for " + groupId + " and " + artifactId);
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        if (!StringUtils.hasText((String)artifactId)) {
            LOGGER.warn("artifactId is empty. Cannot search for artifacts.");
            return artifactList;
        }
        if (!this.canConnect()) {
            LOGGER.warn("Please validate your repository connection configuration under the global config.");
            return artifactList;
        }
        ArrayList versions = new ArrayList();
        TreeSet<String> versionsSet = new TreeSet<String>();
        Artifactory artifactory = ArtifactoryClient.create((String)this.repositoryURI.toString(), (String)this.username, (String)this.password);
        List results = artifactory.searches().artifactsByName(artifactId).doSearch();
        for (RepoPath item : results) {
            String itemPath = item.getItemPath();
            String[] split = itemPath.split(artifactId);
            String itemVersion = split[1].replaceAll("/", "");
            String itemGroupId = org.apache.commons.lang.StringUtils.removeEnd((String)split[0], (String)"/").replace("/", ".");
            if (StringUtils.hasText((String)itemGroupId) && itemGroupId.equalsIgnoreCase(groupId)) {
                versionsSet.add(itemVersion);
                continue;
            }
            versionsSet.add(itemVersion);
        }
        versions.addAll(versionsSet);
        Collections.sort(versions);
        Collections.reverse(versions);
        for (String version : versions) {
            artifactList.add(new Artifact(artifactId, version, ""));
        }
        return artifactList;
    }

    private ClientResponse getResponse() {
        Client client = this.buildClient();
        WebResource restResource = client.resource(this.repositoryURI);
        ClientResponse response = (ClientResponse)restResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
        return response;
    }

    private Client buildClient() {
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getState().setCredentials(null, null, -1, this.username, this.password);
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        ApacheHttpClient restClient = ApacheHttpClient.create((ClientConfig)config);
        restClient.setFollowRedirects(Boolean.valueOf(true));
        return restClient;
    }
}

