/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import de.codecentric.jenkins.dashboard.Messages;
import de.codecentric.jenkins.dashboard.ec2.AwsKeyCredentials;
import de.codecentric.jenkins.dashboard.impl.deploy.DeployJobVariables;
import de.codecentric.jenkins.dashboard.impl.deploy.DeployJobVariablesBuilder;
import de.codecentric.jenkins.dashboard.impl.environments.ec2.AwsRegion;
import de.codecentric.jenkins.dashboard.impl.environments.ec2.EC2Connector;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;

public class EnvironmentTagBuilder
extends Builder {
    private String credentials;
    private String region;

    @DataBoundConstructor
    public EnvironmentTagBuilder(String credentials, String region) {
        this.setCredentials(credentials);
        this.setRegion(region);
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        DeployJobVariables jobVariables = this.extractDeployJobVariables(build);
        String message = this.region + " Tagging ENVIRONMENT [" + jobVariables.getEnvironment() + "] with VERSION [" + jobVariables.getVersion() + "]";
        listener.getLogger().println(message);
        EC2Connector connector = EC2Connector.getEC2Connector(this.getCredentials());
        boolean taggingSuccessful = connector.tagEnvironmentWithVersion(Region.getRegion((Regions)Regions.fromName((String)this.region)), jobVariables);
        if (!taggingSuccessful) {
            String failedMessage = "ERROR: Could not tag ENVIRONMENT [" + jobVariables.getEnvironment() + "] with VERSION [" + jobVariables.getVersion() + "]";
            listener.getLogger().println(failedMessage);
        }
        return taggingSuccessful;
    }

    private DeployJobVariables extractDeployJobVariables(AbstractBuild build) {
        String environment = "undefined";
        String version = "undefined";
        List actionList = Util.filter((List)build.getAllActions(), ParametersAction.class);
        for (ParametersAction parametersAction : actionList) {
            List params = parametersAction.getParameters();
            for (ParameterValue parameterValue : params) {
                if ("ENVIRONMENT".equalsIgnoreCase(parameterValue.getName())) {
                    environment = (String)parameterValue.getValue();
                }
                if (!"VERSION".equalsIgnoreCase(parameterValue.getName())) continue;
                version = (String)parameterValue.getValue();
            }
        }
        return DeployJobVariablesBuilder.createBuilder().version(version).environment(environment).build();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillCredentialsItems() {
            ListBoxModel model = new ListBoxModel();
            DomainRequirement domain = new DomainRequirement();
            for (AwsKeyCredentials credentials : CredentialsProvider.lookupCredentials(AwsKeyCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{domain})) {
                model.add(credentials.getId());
            }
            return model;
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel model = new ListBoxModel();
            for (AwsRegion value : AwsRegion.values()) {
                model.add(value.getName(), value.getIdentifier());
            }
            return model;
        }

        public String getDisplayName() {
            return Messages.Environment_DisplayName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }
    }
}

