/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.jenkins.dashboard;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import de.codecentric.jenkins.dashboard.DashboardViewDescriptor;
import de.codecentric.jenkins.dashboard.Environment;
import de.codecentric.jenkins.dashboard.Messages;
import de.codecentric.jenkins.dashboard.api.environments.ServerEnvironment;
import de.codecentric.jenkins.dashboard.api.repositories.Artifact;
import de.codecentric.jenkins.dashboard.api.repositories.RepositoryInterface;
import de.codecentric.jenkins.dashboard.impl.environments.ec2.EC2Connector;
import de.codecentric.jenkins.dashboard.impl.repositories.RepositoryTypes;
import de.codecentric.jenkins.dashboard.impl.repositories.artifactory.ArtifactoryConnector;
import de.codecentric.jenkins.dashboard.impl.repositories.nexus.NexusConnector;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.model.queue.QueueTaskFuture;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class DashboardView
extends View {
    private static final Logger LOGGER = Logger.getLogger(DashboardView.class.getName());
    @Extension
    public static final DashboardViewDescriptor DESCRIPTOR = new DashboardViewDescriptor();
    public static final String PARAM_VERSION = "VERSION";
    public static final String PARAM_ENVIRONMENT = "ENVIRONMENT";
    public static final String PARAM_EC2_REGION = "EC2_REGION";
    public static final String PARAM_AWS_KEY = "AWS_KEY";
    private boolean showDeployField;
    private String groupId = "";
    private String artefactId = "";
    private List<Environment> environments;

    public DashboardView(String name) {
        super(name);
    }

    public DashboardView(String name, ViewGroup owner) {
        super(name, owner);
    }

    @DataBoundConstructor
    public DashboardView(String name, boolean showDeployField, String groupId, String artefactId, List<Environment> environments) {
        this(name);
        this.setShowDeployField(showDeployField);
        this.setGroupId(groupId);
        this.setArtefactId(artefactId);
        this.setEnvironments(environments);
    }

    public ViewDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public Collection<TopLevelItem> getItems() {
        return new ArrayList<TopLevelItem>();
    }

    public boolean contains(TopLevelItem item) {
        return false;
    }

    @JavaScriptMethod
    public String deploy(String version, String environment) {
        LOGGER.info("Deploy version " + version + " to environment " + environment);
        Environment buildEnvironment = null;
        for (Environment env : this.environments) {
            if (!env.getAwsInstance().equals(environment)) continue;
            buildEnvironment = env;
            break;
        }
        AbstractProject buildJob = (AbstractProject)Jenkins.getInstance().getItemByFullName(buildEnvironment.getBuildJob(), AbstractProject.class);
        LOGGER.info("Executing job: " + buildJob);
        if (buildJob == null) {
            return String.format(Messages.DashboardView_buildJobNotFound(), buildEnvironment.getName());
        }
        if (!buildJob.isBuildable() || !buildJob.isParameterized()) {
            return Messages.DashboardView_deploymentCannotBeExecuted();
        }
        ParametersAction versionParam = new ParametersAction(new ParameterValue[]{new StringParameterValue(PARAM_VERSION, version)});
        ParametersAction environmentParam = new ParametersAction(new ParameterValue[]{new StringParameterValue(PARAM_ENVIRONMENT, environment)});
        ParametersAction ec2RegionParam = new ParametersAction(new ParameterValue[]{new StringParameterValue(PARAM_EC2_REGION, environment)});
        ParametersAction awsKeyParam = new ParametersAction(new ParameterValue[]{new StringParameterValue(PARAM_AWS_KEY, environment)});
        List<ParametersAction> actions = Arrays.asList(versionParam, environmentParam, ec2RegionParam, awsKeyParam);
        QueueTaskFuture scheduledBuild = buildJob.scheduleBuild2(2, (Cause)new Cause.UserIdCause(), actions);
        Result result = Result.FAILURE;
        try {
            AbstractBuild finishedBuild = (AbstractBuild)scheduledBuild.get();
            result = finishedBuild.getResult();
            LOGGER.info("Build finished with result: " + result + " completed in: " + finishedBuild.getDurationString() + ". ");
        }
        catch (Exception e) {
            LOGGER.severe("Error while waiting for build " + scheduledBuild.toString() + ".");
            LOGGER.severe(e.getMessage());
            LOGGER.severe(ExceptionUtils.getFullStackTrace((Throwable)e));
            return String.format(Messages.DashboardView_buildJobFailed(), buildJob.getName());
        }
        if (result == Result.SUCCESS) {
            return String.format(Messages.DashboardView_buildJobScheduledSuccessfully(), buildJob.getName());
        }
        return String.format(Messages.DashboardView_buildJobSchedulingFailed(), buildJob.getName());
    }

    protected synchronized void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        LOGGER.info("DashboardView submit configuration");
        req.bindJSON((Object)this, req.getSubmittedForm());
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Jenkins.getInstance().doCreateItem(req, rsp);
    }

    public String getDisplayDeployField() {
        return this.showDeployField ? "" : "display:none;";
    }

    public boolean getShowDeployField() {
        return this.showDeployField;
    }

    public void setShowDeployField(boolean showDeployField) {
        this.showDeployField = showDeployField;
    }

    public String getArtefactId() {
        return this.artefactId;
    }

    public void setArtefactId(String artefactId) {
        this.artefactId = artefactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public List<Artifact> getArtifacts() {
        RepositoryInterface repository;
        LOGGER.info("Getting artifacts for " + DESCRIPTOR.getRepositoryType());
        if (DESCRIPTOR.getRepositoryType() == null) {
            return new ArrayList<Artifact>();
        }
        try {
            repository = this.createRepository();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return new ArrayList<Artifact>();
        }
        return repository.getArtefactList(this.groupId, this.artefactId);
    }

    private RepositoryInterface createRepository() throws URISyntaxException {
        URI repositoryURI = new URI(DESCRIPTOR.getRepositoryRestUri());
        RepositoryInterface repository = DESCRIPTOR.getRepositoryType().equalsIgnoreCase(RepositoryTypes.ARTIFACTORY.getid()) ? new ArtifactoryConnector(DESCRIPTOR.getUsername(), DESCRIPTOR.getPassword(), repositoryURI) : new NexusConnector(DESCRIPTOR.getUsername(), DESCRIPTOR.getPassword(), repositoryURI);
        return repository;
    }

    public List<ServerEnvironment> getMatchingEC2Environments() {
        ArrayList<ServerEnvironment> list = new ArrayList<ServerEnvironment>();
        for (Environment env : this.environments) {
            EC2Connector envConn = EC2Connector.getEC2Connector(env.getCredentials());
            if (envConn == null || !envConn.areAwsCredentialsValid()) {
                LOGGER.info("Invalid credentials in environment '" + env.getName() + "'");
                continue;
            }
            List<ServerEnvironment> foundEnvironments = envConn.getEnvironmentsByTag(Region.getRegion((Regions)Regions.fromName((String)env.getRegion())), env.getAwsInstance());
            this.updateEnvironmentsWithUrlPrePostFix(foundEnvironments, env);
            list.addAll(foundEnvironments);
        }
        return list;
    }

    private void updateEnvironmentsWithUrlPrePostFix(List<ServerEnvironment> foundEnvironments, Environment environment) {
        for (ServerEnvironment serverEnvironment : foundEnvironments) {
            serverEnvironment.setUrlPrefix(environment.getUrlPrefix());
            serverEnvironment.setUrlPostfix(environment.getUrlPostfix());
            if (!serverEnvironment.getType().equals((Object)ServerEnvironment.ENVIRONMENT_TYPES.DEFAULT)) continue;
            serverEnvironment.setType(ServerEnvironment.ENVIRONMENT_TYPES.getType(environment.getEnvironmentType()));
        }
    }

    public List<Environment> getEnvironments() {
        return Collections.unmodifiableList(this.environments);
    }

    public void setEnvironments(List<Environment> environmentsList) {
        this.environments = environmentsList == null ? new ArrayList<Environment>() : new ArrayList<Environment>(environmentsList);
    }
}

