/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.distfork;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.distfork.DistForkTask;
import hudson.plugins.distfork.PortForwardingArgumentHandler;
import hudson.plugins.distfork.PortSpec;
import hudson.plugins.distfork.RestOfArgumentsHandler;
import hudson.plugins.distfork.RootCutOffFilter;
import hudson.plugins.distfork.TimestampFilter;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.remoting.forward.Forwarder;
import hudson.remoting.forward.ForwarderFactory;
import hudson.remoting.forward.PortForwarder;
import hudson.util.DirScanner;
import hudson.util.StreamTaskListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import jenkins.security.SlaveToMasterCallable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

@Extension
public class DistForkCommand
extends CLICommand {
    @Option(name="-l", usage="Label for controlling where to execute this command")
    public String label;
    @Option(name="-n", usage="Human readable name that describe this command. Used in Jenkins' UI.")
    public String name;
    @Option(name="-d", usage="Estimated duration of this task in milliseconds, or -1 if unknown")
    public long duration = -1L;
    @Argument(handler=RestOfArgumentsHandler.class)
    public List<String> commands = new ArrayList<String>();
    @Option(name="-z", metaVar="FILE", usage="Zip/tgz file to be extracted into the target remote machine before execution of the command")
    public String zip;
    @Option(name="-Z", metaVar="FILE", usage="Bring back the newly added/updated files in the target remote machine after the end of the command by creating a zip/tgz bundle and place this in the local file system by this name.")
    public String returnZip;
    @Option(name="-e", usage="Environment variables to set to the launched process", metaVar="NAME=VAL")
    public Map<String, String> envs = new HashMap<String, String>();
    @Option(name="-f", usage="Local files to be copied to remote locations before the execution of a task", metaVar="REMOTE=LOCAL")
    public Map<String, String> files = new HashMap<String, String>();
    @Option(name="-F", usage="Remote files to be copied back to local locations after the execution of a task", metaVar="LOCAL=REMOTE")
    public Map<String, String> returnFiles = new HashMap<String, String>();
    @Option(name="-L", usage="Local to remote port forwarding", handler=PortForwardingArgumentHandler.class)
    public List<PortSpec> l2rFowrarding = new ArrayList<PortSpec>();
    @Option(name="-R", usage="Remote to local port forwarding", handler=PortForwardingArgumentHandler.class)
    public List<PortSpec> r2lFowrarding = new ArrayList<PortSpec>();

    public String getShortDescription() {
        return "forks a process on a remote machine and connects to its stdin/stdout";
    }

    protected int run() throws Exception {
        if (this.commands.isEmpty()) {
            throw new CmdLineException(null, "No commands are specified");
        }
        Hudson h = Hudson.getInstance();
        Label l = null;
        if (this.label != null && (l = h.getLabel(this.label)).isEmpty()) {
            this.stderr.println("No such label: " + this.label);
            return -1;
        }
        if (this.name == null) {
            boolean dots = false;
            if (this.commands.size() > 3) {
                this.name = Util.join(this.commands.subList(0, 3), (String)" ");
                dots = true;
            }
            this.name = Util.join(this.commands, (String)" ");
            if (this.name.length() > 80) {
                this.name = this.name.substring(0, 80);
                dots = true;
            }
            if (dots) {
                this.name = this.name + " ...";
            }
        }
        final int[] exitCode = new int[]{-1};
        DistForkTask t = new DistForkTask(l, this.name, this.duration, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StreamTaskListener listener = new StreamTaskListener((OutputStream)DistForkCommand.this.stdout, Charset.defaultCharset());
                try {
                    Computer c = Computer.currentComputer();
                    Node n = c.getNode();
                    String nodeName = n.getNodeName().equals("") ? "master" : n.getNodeName();
                    listener.getLogger().println("Executing on " + nodeName);
                    FilePath workDir = n.getRootPath().createTempDir("distfork", null);
                    if (DistForkCommand.this.zip != null) {
                        BufferedInputStream in = new BufferedInputStream(new FilePath((VirtualChannel)DistForkCommand.this.channel, DistForkCommand.this.zip).read());
                        if (DistForkCommand.this.zip.endsWith(".zip")) {
                            workDir.unzipFrom((InputStream)in);
                        } else {
                            workDir.untarFrom((InputStream)in, FilePath.TarCompression.GZIP);
                        }
                    }
                    for (Map.Entry<String, String> e : DistForkCommand.this.files.entrySet()) {
                        new FilePath((VirtualChannel)DistForkCommand.this.channel, e.getValue()).copyToWithPermission(workDir.child(e.getKey()));
                    }
                    ArrayList<Closeable> cleanUpList = new ArrayList<Closeable>();
                    this.setUpPortForwarding(DistForkCommand.this.l2rFowrarding, (VirtualChannel)DistForkCommand.this.channel, c.getChannel(), cleanUpList);
                    this.setUpPortForwarding(DistForkCommand.this.r2lFowrarding, c.getChannel(), (VirtualChannel)DistForkCommand.this.channel, cleanUpList);
                    try {
                        long startTime = (Long)c.getChannel().call((Callable)new GetSystemTime());
                        Launcher launcher = n.createLauncher((TaskListener)listener);
                        exitCode[0] = launcher.launch().cmds(DistForkCommand.this.commands).stdin(DistForkCommand.this.stdin).stdout((OutputStream)DistForkCommand.this.stdout).stderr((OutputStream)DistForkCommand.this.stderr).pwd(workDir).envs(DistForkCommand.this.envs).join();
                        if (!DistForkCommand.this.returnFiles.isEmpty() || DistForkCommand.this.returnZip != null) {
                            DistForkCommand.this.stderr.println("Copying back files");
                            for (Map.Entry<String, String> e : DistForkCommand.this.returnFiles.entrySet()) {
                                FilePath tmp = new FilePath((VirtualChannel)DistForkCommand.this.channel, e.getKey() + ".tmp");
                                FilePath actual = new FilePath((VirtualChannel)DistForkCommand.this.channel, e.getKey());
                                workDir.child(e.getValue()).copyToWithPermission(tmp);
                                if (actual.exists()) {
                                    actual.delete();
                                }
                                tmp.renameTo(actual);
                            }
                            if (DistForkCommand.this.returnZip != null) {
                                BufferedOutputStream os;
                                block19: {
                                    os = new BufferedOutputStream(new FilePath((VirtualChannel)DistForkCommand.this.channel, DistForkCommand.this.returnZip).write());
                                    try {
                                        RootCutOffFilter scanner = new RootCutOffFilter(new TimestampFilter(startTime));
                                        if (DistForkCommand.this.returnZip.endsWith(".zip")) {
                                            workDir.zip((OutputStream)os, (DirScanner)scanner);
                                            break block19;
                                        }
                                        workDir.tar(FilePath.TarCompression.GZIP.compress((OutputStream)os), (DirScanner)scanner);
                                    }
                                    catch (Throwable throwable) {
                                        ((OutputStream)os).close();
                                        throw throwable;
                                    }
                                }
                                ((OutputStream)os).close();
                            }
                        }
                    }
                    finally {
                        workDir.deleteRecursive();
                        for (Closeable cl : cleanUpList) {
                            cl.close();
                        }
                    }
                }
                catch (InterruptedException e) {
                    listener.error("Aborted");
                    exitCode[0] = -1;
                }
                catch (Exception e) {
                    e.printStackTrace(listener.error("Failed to execute a process"));
                    exitCode[0] = -1;
                }
            }

            private void setUpPortForwarding(List<PortSpec> fowrarding, VirtualChannel recv, VirtualChannel send, List<Closeable> cleanUpList) throws IOException, InterruptedException {
                for (PortSpec spec : fowrarding) {
                    Forwarder f = ForwarderFactory.create((VirtualChannel)send, (String)spec.forwardingHost, (int)spec.forwardingPort);
                    cleanUpList.add((Closeable)PortForwarder.create((VirtualChannel)recv, (int)spec.receivingPort, (Forwarder)f));
                }
            }
        });
        Queue q = h.getQueue();
        QueueTaskFuture f = q.schedule((Queue.Task)t, 0).getFuture();
        try {
            f.get();
        }
        catch (CancellationException e) {
            this.stderr.println("Task cancelled");
            return -1;
        }
        catch (InterruptedException e) {
            f.cancel(true);
            throw e;
        }
        return exitCode[0];
    }

    private static final class GetSystemTime
    extends SlaveToMasterCallable<Long, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetSystemTime() {
        }

        public Long call() {
            return System.currentTimeMillis();
        }
    }
}

