/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi.actions;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.actions.AbstractDisplayAction;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class RunDisplayAction
extends AbstractDisplayAction {
    private final Run run;

    RunDisplayAction(Run run) {
        this.run = run;
    }

    @Override
    protected String getRedirectURL(DisplayURLProvider provider) {
        String url;
        StaplerRequest req = Stapler.getCurrentRequest();
        String page = req.getParameter("page");
        if ("changes".equals(page)) {
            url = provider.getChangesURL(this.run);
        } else if ("test".equals(page)) {
            String id = req.getParameter("id");
            if (id == null) {
                throw new IllegalArgumentException("id parameter not specified");
            }
            AbstractTestResultAction action = (AbstractTestResultAction)this.run.getAction(AbstractTestResultAction.class);
            if (action == null) {
                throw new IllegalStateException("No AbstractTestResultAction on this run");
            }
            TestResult result = action.findCorrespondingResult(id);
            url = provider.getTestUrl(result);
        } else {
            url = provider.getRunURL(this.run);
        }
        return url;
    }

    @Extension
    public static class TransientActionFactoryImpl
    extends TransientActionFactory {
        public Class type() {
            return Run.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull Object target) {
            return ImmutableList.of((Object)new RunDisplayAction((Run)target));
        }
    }
}

