/*
 * Decompiled with CFR 0.152.
 */
package info.noirbizarre.jenkins.plugins;

import hudson.Extension;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import info.noirbizarre.jenkins.plugins.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DescriptionColumn
extends ListViewColumn {
    private boolean displayName;
    private boolean trim;
    private int displayLength;
    private static final String SEPARATOR = "<br/>";
    private static final String SEPARATORS_REGEX = "(?i)<br\\s*/>|<br>";

    @DataBoundConstructor
    public DescriptionColumn(boolean displayName, boolean trim, int displayLength) {
        this.displayName = displayName;
        this.trim = trim;
        this.displayLength = displayLength;
    }

    public boolean isDisplayName() {
        return this.displayName;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public int getDisplayLength() {
        return this.displayLength;
    }

    public String formatDescription(Job job) {
        if (job == null) {
            return null;
        }
        if (job.getDescription() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.displayName) {
            sb.append("<b>").append(job.getDisplayName()).append("</b><br/>");
        }
        if (!this.trim) {
            sb.append(job.getDescription());
        } else {
            String[] parts = job.getDescription().split(SEPARATORS_REGEX);
            for (int i = 0; i < this.displayLength && i < parts.length; ++i) {
                if (i != 0) {
                    sb.append(SEPARATOR);
                }
                sb.append(parts[i]);
            }
        }
        return sb.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.DescriptionColumn_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/description-column-plugin/description-column-help.html";
        }
    }
}

