/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.targets;

import com.cloudbees.plugins.deployer.sources.DeploySource;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public abstract class DeployTarget<T extends DeployTarget<T>>
extends AbstractDescribableImpl<T>
implements ExtensionPoint,
Serializable {
    @CheckForNull
    private final DeploySource artifact;

    protected DeployTarget(@CheckForNull DeploySource artifact) {
        this.artifact = artifact;
    }

    @CheckForNull
    public DeploySource getArtifact() {
        return this.artifact;
    }

    public abstract String getDisplayName();

    public boolean isValid(Run<?, ?> run) {
        if (this.isComplete() && this.artifact != null) {
            File artifactFile = this.artifact.getApplicationFile(run);
            return artifactFile != null && this.isArtifactFileValid(artifactFile);
        }
        return false;
    }

    protected abstract boolean isArtifactFileValid(File var1);

    protected abstract boolean isComplete();

    public String toString() {
        StringBuilder sb = new StringBuilder("DeployTarget{");
        sb.append("artifact=").append(this.artifact);
        sb.append('}');
        return sb.toString();
    }

    public static String expandAllMacros(AbstractBuild<?, ?> context, TaskListener listener, String stringPerhapsWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        if (StringUtils.isBlank((String)stringPerhapsWithMacro)) {
            return stringPerhapsWithMacro;
        }
        int index = stringPerhapsWithMacro.indexOf("${");
        if (index == -1) {
            return stringPerhapsWithMacro;
        }
        return TokenMacro.expandAll(context, (TaskListener)listener, (String)stringPerhapsWithMacro);
    }
}

