/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowRunAction;
import com.cloudbees.plugins.deployer.DeployNowSlave;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.ResourceList;
import hudson.model.Run;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.AbstractQueueTask;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.SubTask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class DeployNowTask
extends AbstractQueueTask {
    private final AbstractBuild<?, ?> build;
    private final String name;
    private final DeployNowRunAction.Deployer deployer;
    private volatile transient long nextCheckForNode;

    public DeployNowTask(AbstractBuild<?, ?> build, DeployNowRunAction.Deployer deployer) {
        this.build = build;
        this.name = " \u2192 " + deployer.getDisplayName();
        this.deployer = deployer;
    }

    public boolean isBuildBlocked() {
        return this.getCauseOfBlockage() != null;
    }

    @Deprecated
    public String getWhyBlocked() {
        CauseOfBlockage causeOfBlockage = this.getCauseOfBlockage();
        return causeOfBlockage == null ? null : causeOfBlockage.getShortDescription();
    }

    public CauseOfBlockage getCauseOfBlockage() {
        if (System.currentTimeMillis() > this.nextCheckForNode) {
            this.nextCheckForNode = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
            Computer.threadPoolForRemoting.submit(new Runnable(){

                @Override
                public void run() {
                    DeployNowSlave.ensurePresent();
                }
            });
        }
        return null;
    }

    public String getName() {
        return this.build.getDisplayName() + this.name;
    }

    public String getFullDisplayName() {
        return this.build.getFullDisplayName() + this.name;
    }

    public void checkAbortPermission() {
    }

    public boolean hasAbortPermission() {
        return false;
    }

    public String getUrl() {
        return this.build.getUrl() + "deploy-now/deploy";
    }

    public boolean isConcurrentBuild() {
        return false;
    }

    public ResourceList getResourceList() {
        return new ResourceList();
    }

    public String getDisplayName() {
        return this.build.getDisplayName() + this.name;
    }

    public Label getAssignedLabel() {
        return new LabelAtom("CloudBees Deploy Now Node");
    }

    public Node getLastBuiltOn() {
        return null;
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    public Queue.Executable createExecutable() throws IOException {
        return new ExecutableImpl();
    }

    public Object getSameNodeConstraint() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeployNowTask that = (DeployNowTask)((Object)o);
        if (this.build != null ? !this.build.equals(that.build) : that.build != null) {
            return false;
        }
        return !(this.deployer != null ? !this.deployer.equals(that.deployer) : that.deployer != null);
    }

    public int hashCode() {
        return this.build != null ? this.build.hashCode() : 0;
    }

    public DeployNowRunAction.Deployer getDeployer() {
        return this.deployer;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    private class ExecutableImpl
    implements Queue.Executable {
        private ExecutableImpl() {
        }

        public SubTask getParent() {
            return DeployNowTask.this;
        }

        public void run() {
            DeployNowRunAction action = (DeployNowRunAction)DeployNowTask.this.build.getAction(DeployNowRunAction.class);
            if (action == null) {
                action = new DeployNowRunAction((Run<?, ?>)DeployNowTask.this.build);
            }
            action.run(DeployNowTask.this.deployer);
        }

        public long getEstimatedDuration() {
            return -1L;
        }
    }
}

