/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowComputer;
import com.cloudbees.plugins.deployer.DeployNowTask;
import com.cloudbees.plugins.deployer.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.EphemeralNode;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.util.ClockDifference;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.export.Exported;

public class DeployNowSlave
extends Slave
implements EphemeralNode {
    public static final String NODE_LABEL_STRING = "CloudBees Deploy Now Node";

    public DeployNowSlave() throws Descriptor.FormException, IOException {
        super(Messages.DeployNowSlave_NodeName(), Messages.DeployNowSlave_NodeDescription(), "", 1, Node.Mode.EXCLUSIVE, null, null, (RetentionStrategy)DeployNowComputer.RETENTION_STRATEGY, Collections.singletonList(new NodePropertyImpl()));
    }

    @Exported
    public Set<LabelAtom> getAssignedLabels() {
        TreeSet<LabelAtom> r = new TreeSet<LabelAtom>(super.getAssignedLabels());
        r.add(new LabelAtom(NODE_LABEL_STRING));
        return Collections.unmodifiableSet(r);
    }

    public Launcher createLauncher(TaskListener listener) {
        return new Launcher.LocalLauncher(listener).decorateFor((Node)this);
    }

    public Computer createComputer() {
        return new DeployNowComputer(this);
    }

    public FilePath getWorkspaceFor(TopLevelItem item) {
        return Hudson.getInstance().getWorkspaceFor(item);
    }

    public FilePath getRootPath() {
        return Hudson.getInstance().getRootPath();
    }

    public ClockDifference getClockDifference() throws IOException, InterruptedException {
        return ClockDifference.ZERO;
    }

    public static synchronized DeployNowSlave ensurePresent() {
        return DeployNowComputer.RETENTION_STRATEGY.ensurePresent();
    }

    public Node asNode() {
        return this;
    }

    public static class NodePropertyImpl
    extends NodeProperty<DeployNowSlave> {
        public CauseOfBlockage canTake(Queue.BuildableItem item) {
            if (item.task instanceof DeployNowTask) {
                return null;
            }
            return CauseOfBlockage.fromMessage((Localizable)Messages._DeployNowSlave_OnlyAcceptsDeployNowTasks());
        }

        @Extension
        public static class DescriptorImpl
        extends NodePropertyDescriptor {
            public String getDisplayName() {
                return "Deploy Now Agent Property";
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public boolean isInstantiable() {
            return false;
        }

        public String getDisplayName() {
            return "Deploy Now Agent";
        }
    }
}

