/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.sources;

import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FixedDirectoryDeploySource
extends DeploySource {
    private static final Logger LOGGER = Logger.getLogger(FixedDirectoryDeploySource.class.getName());
    @NonNull
    private final String directoryPath;

    @DataBoundConstructor
    public FixedDirectoryDeploySource(@CheckForNull String directoryPath) {
        this.directoryPath = StringUtils.trimToEmpty((String)directoryPath);
    }

    @NonNull
    public String getDirectoryPath() {
        return this.directoryPath;
    }

    @Override
    @CheckForNull
    public File getApplicationFile(@NonNull Run run) {
        return null;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Might be null if serialized")
    public FilePath getApplicationFile(@NonNull FilePath workspace) {
        return this.directoryPath == null ? workspace : workspace.child(this.directoryPath);
    }

    @NonNull
    public String toString() {
        return this.directoryPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedDirectoryDeploySource that = (FixedDirectoryDeploySource)o;
        return this.directoryPath.equals(that.directoryPath);
    }

    public int hashCode() {
        return this.directoryPath.hashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends DeploySourceDescriptor {
        @Override
        public boolean isSupported(@CheckForNull DeploySourceOrigin origin) {
            return DeploySourceOrigin.WORKSPACE.equals((Object)origin);
        }

        @Override
        public boolean isDirectorySource() {
            return true;
        }

        @Override
        public boolean isFileSource() {
            return false;
        }

        public String getDisplayName() {
            return "Fixed directory";
        }

        @Override
        public DeploySource newInstance() {
            return new FixedDirectoryDeploySource(null);
        }

        public FormValidation doCheckDirectoryPath(@QueryParameter @RelativePath(value="..") String fromWorkspace, @QueryParameter String targetDescriptorId, @QueryParameter String value) throws IOException, ServletException, InterruptedException {
            Job job;
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.warning((String)"You really should specify a directory, otherwise '.' is assumed");
            }
            if (Boolean.valueOf(fromWorkspace).booleanValue() && (job = this.findJob()) != null && job instanceof AbstractProject) {
                FilePath someWorkspace = ((AbstractProject)job).getSomeWorkspace();
                if (someWorkspace == null) {
                    return FormValidation.warning((String)("The workspace is empty. Unable to validate '" + value + "'."));
                }
                FilePath dirPath = someWorkspace.child(value);
                if (dirPath.exists()) {
                    if (dirPath.isDirectory()) {
                        return this.delegatePathValidationToTarget(value, targetDescriptorId, dirPath);
                    }
                    return FormValidation.error((String)("The specified path, '" + value + "' currently is a file."));
                }
                return FormValidation.warning((String)("The specified path '" + value + "' currently does not exist."));
            }
            return FormValidation.warning((String)("Could not find a directory that matches '" + value + "'"));
        }
    }
}

