/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.engines;

import com.cloudbees.plugins.deployer.engines.Engine;
import com.cloudbees.plugins.deployer.engines.EngineConfiguration;
import com.cloudbees.plugins.deployer.engines.EngineFactoryDescriptor;
import com.cloudbees.plugins.deployer.exceptions.DeployException;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildListener;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.acegisecurity.Authentication;

public abstract class EngineFactory<S extends DeployHost<S, T>, T extends DeployTarget<T>>
extends AbstractDescribableImpl<EngineFactory<S, T>> {
    private EngineConfiguration<S, T> configuration;

    protected EngineFactory(@NonNull S configuration) {
        configuration.getClass();
        this.configuration = new EngineConfiguration(configuration);
    }

    public EngineFactoryDescriptor<S, T> getDescriptor() {
        return (EngineFactoryDescriptor)super.getDescriptor();
    }

    @NonNull
    public EngineFactory<S, T> withCredentials(@Nullable Item scope, Authentication ... authentications) {
        this.configuration = this.configuration.withDeployScope(scope).withDeployAuthentications(new ArrayList<Authentication>(Arrays.asList(authentications)));
        return this;
    }

    @NonNull
    public EngineFactory<S, T> withCredentials(@Nullable Item scope, @CheckForNull Collection<Authentication> authentications) {
        this.configuration = this.configuration.withDeployScope(scope).withDeployAuthentications(authentications == null ? new ArrayList<Authentication>() : new ArrayList<Authentication>(authentications));
        return this;
    }

    @NonNull
    public EngineFactory<S, T> from(@NonNull AbstractBuild<?, ?> build, DeploySourceOrigin ... sources) {
        build.getClass();
        this.configuration = this.configuration.withBuild(build).withSources(new LinkedHashSet<DeploySourceOrigin>(Arrays.asList(sources)));
        return this;
    }

    @NonNull
    public EngineFactory<S, T> from(@NonNull AbstractBuild<?, ?> build, Collection<DeploySourceOrigin> sources) {
        build.getClass();
        this.configuration = this.configuration.withBuild(build).withSources((Set<DeploySourceOrigin>)(sources == null ? Collections.emptySet() : new LinkedHashSet<DeploySourceOrigin>(sources)));
        return this;
    }

    @NonNull
    public EngineFactory<S, T> withListener(@NonNull BuildListener listener) {
        listener.getClass();
        this.configuration = this.configuration.withListener(listener);
        return this;
    }

    @NonNull
    public EngineFactory<S, T> withLauncher(Launcher launcher) {
        launcher.getClass();
        this.configuration = this.configuration.withLauncher(launcher);
        return this;
    }

    @NonNull
    public abstract Engine<S, T> build() throws DeployException;

    public EngineConfiguration<S, T> getConfiguration() {
        return this.configuration;
    }
}

