/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.graph;

import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.DependencyEdge;
import hudson.plugins.depgraph_view.model.graph.Edge;
import hudson.plugins.depgraph_view.model.graph.EdgeProvider;
import java.util.ArrayList;
import javax.inject.Inject;
import jenkins.model.Jenkins;

public class DependencyGraphEdgeProvider
implements EdgeProvider {
    private DependencyGraph dependencyGraph;

    @Inject
    public DependencyGraphEdgeProvider(Jenkins jenkins) {
        this.dependencyGraph = jenkins.getDependencyGraph();
    }

    @Override
    public Iterable<Edge> getEdgesIncidentWith(AbstractProject<?, ?> project) {
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(this.dependencyGraph.getDownstreamDependencies(project));
        dependencies.addAll(this.dependencyGraph.getUpstreamDependencies(project));
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (DependencyGraph.Dependency dependency : dependencies) {
            edges.add(new DependencyEdge(dependency));
        }
        return edges;
    }
}

