/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.display;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hudson.plugins.depgraph_view.model.display.AbstractDotStringGenerator;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;

public class LegendDotStringGenerator
extends AbstractDotStringGenerator {
    public LegendDotStringGenerator() {
        super(new DependencyGraph(), (ListMultimap<ProjectNode, ProjectNode>)ArrayListMultimap.create());
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {\n");
        builder.append("node [shape=box, style=rounded];\n");
        builder.append(this.cluster("Legend", this.legend(), new String[0]));
        builder.append("}");
        return builder.toString();
    }

    private String legend() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("label=\"Legend:\" labelloc=t centered=false color=black node [shape=plaintext]").append("\"Dependency Graph\"\n").append("\"Copy Artifact\"\n").append("\"Sub-Project\"\n").append("node [style=invis]\n").append("a [label=\"\"] b [label=\"\"]").append(" c [fillcolor=" + LegendDotStringGenerator.escapeString(this.subProjectColor) + " style=filled fontcolor=" + LegendDotStringGenerator.escapeString(this.subProjectColor) + "]\n").append("a -> b [style=invis]\n").append("{rank=same a -> \"Dependency Graph\" [color=black style=bold minlen=2]}\n").append("{rank=same b -> \"Copy Artifact\" [color=lightblue minlen=2]}\n").append("{rank=same c -> \"Sub-Project\" [ style=invis]}\n");
        return stringBuilder.toString();
    }
}

