/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.display;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.filters.FilterUtils;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import hudson.plugins.depgraph_view.model.display.AbstractGraphStringGenerator;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.Edge;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import hudson.plugins.depgraph_view.model.layout.JungSugiyama;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;

public class JsonStringGenerator
extends AbstractGraphStringGenerator {
    public JsonStringGenerator(DependencyGraph graph, ListMultimap<ProjectNode, ProjectNode> projects2Subprojects) {
        super(graph, projects2Subprojects);
    }

    @Override
    public String generate() {
        ArrayList<Map<String, String>> edges = new ArrayList<Map<String, String>>();
        for (Edge edge : this.edges) {
            this.addEdge(edges, edge);
        }
        ArrayList clusters = Lists.newArrayList((Iterable)new WeakComponentClusterer().transform(this.graph.getGraph()));
        Collections.sort(clusters, Ordering.natural().onResultOf((Function)new Function<Set<ProjectNode>, Integer>(){

            public Integer apply(Set<ProjectNode> input) {
                return input.size();
            }
        }).reverse());
        ArrayList subgraphs = Lists.newArrayList((Iterable)FilterUtils.createAllInducedSubgraphs((Collection)clusters, this.graph.getGraph()));
        ArrayList clusterList = Lists.newArrayList();
        for (Graph subgraph : subgraphs) {
            Point2D point;
            if (subgraph.getVertexCount() == 1) continue;
            JungSugiyama layout = new JungSugiyama(subgraph);
            layout.setSize(new Dimension(300, 800));
            layout.initialize();
            if (layout instanceof IterativeContext) {
                IterativeContext context = (IterativeContext)layout;
                for (int i = 0; i < 700; ++i) {
                    context.step();
                    if (context.done()) break;
                }
            }
            ArrayList nodeList = Lists.newArrayList();
            double minX = 300.0;
            double maxX = 0.0;
            double minY = 800.0;
            double maxY = 0.0;
            for (ProjectNode node : subgraph.getVertices()) {
                point = (Point2D)layout.transform(node);
                if (point.getX() > maxX) {
                    maxX = point.getX();
                }
                if (point.getX() < minX) {
                    minX = point.getX();
                }
                if (point.getY() > maxY) {
                    maxY = point.getY();
                }
                if (!(point.getY() < minY)) continue;
                minY = point.getY();
            }
            for (ProjectNode node : subgraph.getVertices()) {
                point = (Point2D)layout.transform(node);
                nodeList.add(this.point2Json(point.getX() - minX, point.getY() - minY, node));
            }
            Map<String, Object> cluster = this.createCluster(nodeList, maxX - minX, maxY - minY);
            clusterList.add(cluster);
        }
        Map<String, Object> standaloneCluster = this.createStandaloneCluster();
        clusterList.add(standaloneCluster);
        JSONObject json = new JSONObject();
        json.put("edges", edges);
        json.put("clusters", (Object)clusterList);
        String jsonStr = json.toString(2);
        return jsonStr;
    }

    private Map<String, Object> createStandaloneCluster() {
        double nodeXSize = 150.0;
        double nodeYSize = 90.0;
        int nodesPerRow = 5;
        ArrayList nodeList = Lists.newArrayList();
        int row = 0;
        int column = 0;
        for (ProjectNode node : this.standaloneProjects) {
            nodeList.add(this.point2Json((double)column * 150.0, (double)row * 90.0, node));
            if (++column < 5) continue;
            ++row;
            column = 0;
        }
        return this.createCluster(nodeList, 700.0, (double)(this.standaloneProjects.size() / 5 + 1) * 90.0);
    }

    private Map<String, Object> createCluster(List<Map<String, Object>> nodeList, double hSize, double vSize) {
        HashMap cluster = Maps.newHashMap();
        cluster.put("nodes", nodeList);
        cluster.put("hSize", hSize);
        cluster.put("vSize", vSize);
        return cluster;
    }

    private ImmutableMap<String, Object> point2Json(double x, double y, ProjectNode node) {
        return ImmutableMap.builder().put((Object)"name", (Object)node.getName()).put((Object)"fullName", (Object)node.getProject().getFullName()).put((Object)"url", (Object)node.getProject().getAbsoluteUrl()).put((Object)"x", (Object)x).put((Object)"y", (Object)y).build();
    }

    private void addEdge(List<Map<String, String>> edges, Edge edge) {
        HashMap<String, String> jsonEdge = new HashMap<String, String>();
        String fullDisplayNameFrom = edge.source.getName();
        String fullDisplayNameTo = edge.target.getName();
        jsonEdge.put("from", fullDisplayNameFrom);
        jsonEdge.put("to", fullDisplayNameTo);
        jsonEdge.put("type", edge.getType());
        edges.add(jsonEdge);
    }
}

