/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.display;

import com.google.common.base.Function;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import hudson.model.AbstractProject;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.Edge;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractGraphStringGenerator {
    protected static final Comparator<Edge> DEP_COMPARATOR = new Comparator<Edge>(){

        @Override
        public int compare(Edge o1, Edge o2) {
            int down = NODE_COMPARATOR.compare(o1.target, o2.target);
            return down != 0 ? down : NODE_COMPARATOR.compare(o1.source, o2.source);
        }
    };
    protected static final Comparator<ProjectNode> NODE_COMPARATOR = new Comparator<ProjectNode>(){

        @Override
        public int compare(ProjectNode o1, ProjectNode o2) {
            return PROJECT_COMPARATOR.compare(o1.getProject(), o2.getProject());
        }
    };
    protected static final Comparator<AbstractProject<?, ?>> PROJECT_COMPARATOR = new Comparator<AbstractProject<?, ?>>(){

        @Override
        public int compare(AbstractProject<?, ?> o1, AbstractProject<?, ?> o2) {
            return o1.getFullDisplayName().compareTo(o2.getFullDisplayName());
        }
    };
    protected static final Function<ProjectNode, String> PROJECT_NAME_FUNCTION = new Function<ProjectNode, String>(){

        public String apply(ProjectNode from) {
            return from.getName();
        }
    };
    protected ArrayList<ProjectNode> standaloneProjects;
    protected List<ProjectNode> projectsInDeps;
    protected List<Edge> edges;
    protected ListMultimap<ProjectNode, ProjectNode> subJobs;
    protected final DependencyGraph graph;

    protected AbstractGraphStringGenerator(DependencyGraph graph, ListMultimap<ProjectNode, ProjectNode> projects2Subprojects) {
        this.graph = graph;
        this.subJobs = projects2Subprojects;
        this.edges = Lists.newArrayList(graph.getEdges());
        Collections.sort(this.edges, DEP_COMPARATOR);
        this.standaloneProjects = Lists.newArrayList(graph.getIsolatedNodes());
        Collections.sort(this.standaloneProjects, NODE_COMPARATOR);
        this.projectsInDeps = Lists.newArrayList(graph.getNodes());
        this.projectsInDeps.removeAll(this.standaloneProjects);
        Collections.sort(this.projectsInDeps, NODE_COMPARATOR);
    }

    public abstract String generate();
}

