/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.tools;

import hudson.model.Computer;
import hudson.model.Node;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.tools.DetectionFailedException;

public enum Platform {
    LINUX(".sh"),
    WINDOWS(".bat");

    public final String cmdExtension;

    private Platform(String cmdExtension) {
        this.cmdExtension = cmdExtension;
    }

    public boolean is(String line) {
        return line.contains(this.name());
    }

    public static Platform of(Node node) throws DetectionFailedException {
        try {
            Computer computer = node.toComputer();
            if (computer == null) {
                throw new DetectionFailedException(Messages.SystemTools_nodeNotAvailable(node.getDisplayName()));
            }
            return Platform.detect(computer.getSystemProperties());
        }
        catch (IOException | InterruptedException e) {
            throw new DetectionFailedException(Messages.SystemTools_failureOnProperties(), e);
        }
    }

    public static Platform current() throws DetectionFailedException {
        return Platform.detect(System.getProperties());
    }

    private static Platform detect(Map<Object, Object> systemProperties) {
        String arch = ((String)systemProperties.get("os.name")).toLowerCase(Locale.ENGLISH);
        if (arch.contains("windows")) {
            return WINDOWS;
        }
        return LINUX;
    }
}

