/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;

public class FindingsAggregator {
    private final SeverityDistribution severityDistribution;
    private final List<Finding> aggregatedFindings;

    public FindingsAggregator(int buildNumber) {
        this.severityDistribution = new SeverityDistribution(buildNumber);
        this.aggregatedFindings = new ArrayList<Finding>();
    }

    public void addFindings(List<Finding> findings) {
        for (Finding finding : findings) {
            if (!this.aggregatedFindings.contains(finding)) {
                this.aggregatedFindings.add(finding);
                this.severityDistribution.add(finding.getNormalizedSeverity());
                continue;
            }
            int idx = this.aggregatedFindings.indexOf(finding);
            this.aggregatedFindings.get(idx).increaseCount();
        }
    }

    public SeverityDistribution getSeverityDistribution() {
        return this.severityDistribution;
    }

    public List<Finding> getAggregatedFindings() {
        return this.aggregatedFindings;
    }
}

