/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.InstallSourceProperty;
import hudson.triggers.SCMTrigger;
import hudson.util.ArgumentListBuilder;
import hudson.util.QuotedStringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyCheck.DependencyCheckUtil;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstallation;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstaller;
import org.jenkinsci.plugins.DependencyCheck.tools.Version;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DependencyCheckToolBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 4267818809512542424L;
    private final String odcInstallation;
    private String additionalArguments;
    private boolean skipOnScmChange;
    private boolean skipOnUpstreamChange;
    private boolean stopBuild = false;

    @DataBoundConstructor
    public DependencyCheckToolBuilder(String odcInstallation) {
        this.odcInstallation = Util.fixEmptyAndTrim((String)odcInstallation);
    }

    public String getOdcInstallation() {
        return this.odcInstallation;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @DataBoundSetter
    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public boolean isSkipOnScmChange() {
        return this.skipOnScmChange;
    }

    @DataBoundSetter
    public void setSkipOnScmChange(boolean skipOnScmChange) {
        this.skipOnScmChange = skipOnScmChange;
    }

    public boolean isSkipOnUpstreamChange() {
        return this.skipOnUpstreamChange;
    }

    @DataBoundSetter
    public void setSkipOnUpstreamChange(boolean skipOnUpstreamChange) {
        this.skipOnUpstreamChange = skipOnUpstreamChange;
    }

    @DataBoundSetter
    public void setStopBuild(boolean stopBuild) {
        this.stopBuild = stopBuild;
    }

    public boolean isStopBuild() {
        return this.stopBuild;
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        Node node;
        if (this.isSkip(build, listener)) {
            return;
        }
        DependencyCheckInstallation ni = this.getDependencyCheck();
        if (ni == null) {
            if (this.odcInstallation != null) {
                throw new AbortException(Messages.Builder_noInstallationFound(this.odcInstallation));
            }
            throw new AbortException(Messages.Builder_InstallationNotSpecified());
        }
        Computer computer = workspace.toComputer();
        Node node2 = node = computer != null ? computer.getNode() : null;
        if (node == null) {
            throw new AbortException(Messages.Builder_nodeOffline());
        }
        ni = ni.forNode(node, listener);
        String odcScript = (ni = ni.forEnvironment(env)).getExecutable(launcher);
        if (odcScript == null) {
            throw new AbortException(Messages.Builder_noExecutableFound(ni.getHome()));
        }
        ArgumentListBuilder cliArguments = this.buildArgumentList(odcScript, build, workspace, env);
        int exitCode = launcher.launch().cmds(cliArguments).envs((Map)env).stdout((OutputStream)listener.getLogger()).quiet(true).pwd(workspace).join();
        boolean success = this.isSuccess(exitCode);
        if (!success) {
            build.setResult(Result.FAILURE);
            if (this.stopBuild) {
                throw new AbortException(Messages.Publisher_FailBuild());
            }
            listener.error("Mark build as failed because of exit code " + exitCode);
        }
    }

    private boolean isSuccess(int exitCode) {
        Version v;
        DependencyCheckInstaller ui;
        InstallSourceProperty installSourceProperty = (InstallSourceProperty)this.getDependencyCheck().getProperties().get(InstallSourceProperty.class);
        if (installSourceProperty != null && (ui = (DependencyCheckInstaller)installSourceProperty.installers.get(DependencyCheckInstaller.class)) != null && (v = Version.parseVersion(ui.id)).getMajor() < 8) {
            return exitCode == 0;
        }
        return exitCode == 0 || exitCode == 14 || exitCode == 15;
    }

    private DependencyCheckInstallation getDependencyCheck() {
        return DependencyCheckUtil.getDependencyCheck(this.odcInstallation);
    }

    protected ArgumentListBuilder buildArgumentList(@NonNull String odcScript, @NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull EnvVars env) {
        ArgumentListBuilder cliArguments = new ArgumentListBuilder(new String[]{odcScript});
        if (!StringUtils.contains((CharSequence)this.additionalArguments, (CharSequence)"--project")) {
            cliArguments.add(new String[]{"--project", build.getFullDisplayName()});
        }
        if (!StringUtils.containsAny((CharSequence)this.additionalArguments, (CharSequence[])new CharSequence[]{"--scan", "-s "})) {
            cliArguments.add(new String[]{"--scan", workspace.getRemote()});
        }
        if (!StringUtils.containsAny((CharSequence)this.additionalArguments, (CharSequence[])new CharSequence[]{"--format", "-f "})) {
            cliArguments.add(new String[]{"--format", "XML"});
        }
        if (Util.fixEmptyAndTrim((String)this.additionalArguments) != null) {
            for (String addArg : QuotedStringTokenizer.tokenize((String)this.additionalArguments)) {
                if (Util.fixEmptyAndTrim((String)addArg) == null) continue;
                cliArguments.add(Util.replaceMacro((String)addArg, (Map)env));
            }
        }
        return cliArguments;
    }

    private boolean isSkip(Run<?, ?> build, TaskListener listener) {
        boolean skip = false;
        try {
            skip = Boolean.parseBoolean((String)build.getEnvironment(listener).get((Object)"OWASP_DC_SKIP"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (this.skipOnScmChange && cause instanceof SCMTrigger.SCMTriggerCause) {
                skip = true;
            }
            if (!this.skipOnUpstreamChange || !(cause instanceof Cause.UpstreamCause)) continue;
            skip = true;
        }
        if (skip) {
            listener.getLogger().println(Messages.Builder_Skip());
        }
        return skip;
    }

    @Extension
    @Symbol(value={"dependencyCheck", "dependencycheck"})
    public static class DependencyCheckToolBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        private DependencyCheckInstallation[] installations = new DependencyCheckInstallation[0];

        public DependencyCheckInstallation[] loadInstalltions() {
            this.load();
            return this.installations;
        }

        public void purge() {
            XmlFile globalConfig = this.getConfigFile();
            FileUtils.deleteQuietly((File)globalConfig.getFile());
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Builder_Name();
        }

        public DependencyCheckInstallation[] getInstallations() {
            return DependencyCheckUtil.getInstallations();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

