/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.steps;

import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.util.ListBoxModel;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.jenkinsci.plugins.database.PerItemDatabase;
import org.jenkinsci.plugins.database.PerItemDatabaseConfiguration;
import org.jenkinsci.plugins.database.steps.DatabaseContext;
import org.jenkinsci.plugins.database.steps.DatabaseType;
import org.jenkinsci.plugins.database.steps.FailedToGetDatabaseException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DatabaseConnectionStep
extends AbstractStepImpl {
    @Extension(optional=true)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOG = Logger.getLogger(DatabaseConnectionStep.class.getName());
    private DatabaseType type;
    private String id;

    @DataBoundConstructor
    public DatabaseConnectionStep() {
    }

    public DatabaseType getType() {
        return this.type;
    }

    @DataBoundSetter
    public void setType(DatabaseType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setId(@CheckForNull String id) {
        this.id = Util.fixEmptyAndTrim((String)id);
    }

    public StepDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "getDatabaseConnection";
        }

        @Nonnull
        public String getDisplayName() {
            return "Get Database Connection";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillTypeItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseType dataType : DatabaseType.values()) {
                items.add(dataType.getDisplayName(), dataType.name());
            }
            return items;
        }
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run<?, ?> build;
        @StepContextParameter
        private transient TaskListener taskListener;
        @Inject
        private transient DatabaseConnectionStep step;
        @Inject
        private transient GlobalDatabaseConfiguration globalDatabaseConfiguration;
        @Inject
        private transient PerItemDatabaseConfiguration perItemDatabaseConfiguration;
        private transient Connection connection;
        private transient BodyExecution execution;

        public void onResume() {
            throw new RuntimeException("Database operations can't be resumed");
        }

        public boolean start() throws Exception {
            this.fetchDatabase();
            try {
                DatabaseContext dbContext = new DatabaseContext((DatabaseContext)this.getContext().get(DatabaseContext.class), this.connection, this.step.id);
                this.execution = this.getContext().newBodyInvoker().withContext((Object)dbContext).withCallback((BodyExecutionCallback)new BodyExecutionCallback.TailCall(){

                    protected void finished(StepContext context) throws Exception {
                        this.closeConnection();
                    }
                }).start();
                return false;
            }
            catch (Exception e) {
                this.closeConnection();
                this.getContext().onFailure((Throwable)e);
                return true;
            }
        }

        private void fetchDatabase() throws FailedToGetDatabaseException {
            try {
                LOG.log(Level.FINE, "Fetching database connection of type {0}", (Object)this.step.type);
                switch (this.step.type) {
                    default: {
                        Database database = this.globalDatabaseConfiguration.getDatabase();
                        if (database == null) break;
                        this.connection = database.getDataSource().getConnection();
                        break;
                    }
                    case PERITEM: {
                        if (this.build.getParent() instanceof TopLevelItem) {
                            PerItemDatabase perItemDatabase = this.perItemDatabaseConfiguration.getDatabase();
                            if (perItemDatabase == null) break;
                            this.connection = perItemDatabase.getDataSource((TopLevelItem)this.build.getParent()).getConnection();
                            break;
                        }
                        throw new FailedToGetDatabaseException("Failed to get per item database build.getParent is not instance of TopLevelItem? " + this.build.getParent().getClass());
                    }
                }
                LOG.log(Level.FINE, "Got database connection");
            }
            catch (SQLException e) {
                throw new FailedToGetDatabaseException("Failed to get database connection", e);
            }
        }

        private void closeConnection() {
            if (this.connection != null) {
                try {
                    LOG.log(Level.FINE, "Closing database connection");
                    this.connection.close();
                    this.connection = null;
                }
                catch (SQLException e) {
                    this.taskListener.error("Failed to close connection %s", new Object[]{e});
                }
            }
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            LOG.log(Level.FINE, "Recived stop request", cause);
            try {
                if (this.execution != null) {
                    this.execution.cancel(cause);
                    this.execution = null;
                }
            }
            finally {
                this.closeConnection();
            }
        }
    }
}

