/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardLog;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.plugins.view.dashboard.test.LocalDateLabel;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.plugins.view.dashboard.test.TestUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.EnumConverter;
import hudson.util.Graph;
import hudson.util.ListBoxModel;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.Converter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.joda.time.Chronology;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GregorianChronology;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class TestTrendChart
extends DashboardPortlet {
    private int graphWidth = 300;
    private int graphHeight = 220;
    private int dateRange = 365;
    private int dateShift = 0;
    private DisplayStatus displayStatus = DisplayStatus.ALL;

    @DataBoundConstructor
    public TestTrendChart(String name, int graphWidth, int graphHeight, DisplayStatus displayStatus, int dateRange, int dateShift) {
        super(name);
        this.graphWidth = graphWidth;
        this.graphHeight = graphHeight;
        this.dateRange = dateRange;
        this.dateShift = dateShift;
        this.displayStatus = displayStatus;
        DashboardLog.debug("TestTrendChart", "ctor");
    }

    public int getDateRange() {
        return this.dateRange;
    }

    public int getDateShift() {
        return this.dateShift;
    }

    public int getGraphWidth() {
        return this.graphWidth <= 0 ? 300 : this.graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight <= 0 ? 220 : this.graphHeight;
    }

    public DisplayStatus getDisplayStatus() {
        return this.displayStatus;
    }

    @VisibleForTesting
    Map<LocalDate, TestResultSummary> collectData() {
        Comparator<LocalDate> localDateComparator = new Comparator<LocalDate>(){

            @Override
            public int compare(LocalDate d1, LocalDate d2) {
                if (d1.isEqual((ReadablePartial)d2)) {
                    return 0;
                }
                if (d1.isAfter((ReadablePartial)d2)) {
                    return 1;
                }
                return -1;
            }
        };
        TreeMap<LocalDate, TestResultSummary> summaries = new TreeMap<LocalDate, TestResultSummary>(localDateComparator);
        LocalDate today = new LocalDate(System.currentTimeMillis() - (long)(this.dateShift * 6000), (Chronology)GregorianChronology.getInstanceUTC());
        for (Job job : this.getDashboard().getJobs()) {
            LocalDate firstDay;
            Run run = job.getFirstBuild();
            if (run == null) continue;
            LocalDate runDay = new LocalDate(run.getTimeInMillis() - (long)this.dateShift * 60000L, (Chronology)GregorianChronology.getInstanceUTC());
            LocalDate localDate = firstDay = this.dateRange != 0 ? new LocalDate(System.currentTimeMillis() - (long)this.dateShift * 6000L, (Chronology)GregorianChronology.getInstanceUTC()).minusDays(this.dateRange) : runDay;
            while (run != null) {
                runDay = new LocalDate(run.getTimeInMillis() - (long)this.dateShift * 60000L, (Chronology)GregorianChronology.getInstanceUTC());
                Run nextRun = run.getNextBuild();
                if (nextRun != null) {
                    LocalDate nextRunDay = new LocalDate(nextRun.getTimeInMillis() - (long)this.dateShift * 60000L, (Chronology)GregorianChronology.getInstanceUTC());
                    if ((!runDay.isBefore((ReadablePartial)firstDay) || runDay.isBefore((ReadablePartial)firstDay) && !nextRunDay.isBefore((ReadablePartial)firstDay)) && nextRunDay.isAfter((ReadablePartial)runDay)) {
                        this.summarize(summaries, run, runDay.isBefore((ReadablePartial)firstDay) ? firstDay : runDay, nextRunDay.minusDays(1));
                    }
                } else {
                    this.summarize(summaries, run, runDay.isBefore((ReadablePartial)firstDay) ? firstDay : runDay, today);
                }
                run = nextRun;
            }
        }
        return summaries;
    }

    public Graph getSummaryGraph() {
        final CategoryDataset data = this.buildDataSet(this.collectData());
        return new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                JFreeChart chart = ChartFactory.createStackedAreaChart(null, (String)Messages.Dashboard_Date(), (String)Messages.Dashboard_Count(), (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                StackedAreaRenderer2 ar = new StackedAreaRenderer2();
                plot.setRenderer((CategoryItemRenderer)ar);
                switch (TestTrendChart.this.getDisplayStatus()) {
                    case SUCCESS: {
                        ar.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
                        break;
                    }
                    case SKIPPED: {
                        ar.setSeriesPaint(0, (Paint)ColorPalette.YELLOW);
                        break;
                    }
                    case FAILED: {
                        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
                        break;
                    }
                    default: {
                        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
                        ar.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
                        ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
                    }
                }
                plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
                return chart;
            }
        };
    }

    private CategoryDataset buildDataSet(Map<LocalDate, TestResultSummary> summaries) {
        DataSetBuilder dsb = new DataSetBuilder();
        block5: for (Map.Entry<LocalDate, TestResultSummary> entry : summaries.entrySet()) {
            LocalDateLabel label = new LocalDateLabel(entry.getKey());
            switch (this.getDisplayStatus()) {
                case SUCCESS: {
                    dsb.add((Number)entry.getValue().getSuccess(), (Comparable)((Object)Messages.Dashboard_Total()), (Comparable)label);
                    continue block5;
                }
                case SKIPPED: {
                    dsb.add((Number)entry.getValue().getSkipped(), (Comparable)((Object)Messages.Dashboard_Skipped()), (Comparable)label);
                    continue block5;
                }
                case FAILED: {
                    dsb.add((Number)entry.getValue().getFailed(), (Comparable)((Object)Messages.Dashboard_Failed()), (Comparable)label);
                    continue block5;
                }
            }
            dsb.add((Number)entry.getValue().getSuccess(), (Comparable)((Object)Messages.Dashboard_Total()), (Comparable)label);
            dsb.add((Number)entry.getValue().getFailed(), (Comparable)((Object)Messages.Dashboard_Failed()), (Comparable)label);
            dsb.add((Number)entry.getValue().getSkipped(), (Comparable)((Object)Messages.Dashboard_Skipped()), (Comparable)label);
        }
        return dsb.build();
    }

    private void summarize(Map<LocalDate, TestResultSummary> summaries, Run run, LocalDate firstDay, LocalDate lastDay) {
        TestResult testResult = TestUtil.getTestResult(run);
        LocalDate curr = firstDay;
        while (curr.compareTo((ReadablePartial)lastDay) <= 0) {
            if (testResult.getTests() != 0) {
                TestResultSummary trs = summaries.get(curr);
                if (trs == null) {
                    trs = new TestResultSummary();
                    summaries.put(curr, trs);
                }
                trs.addTestResult(testResult);
            }
            curr = curr.plusDays(1);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_TestTrendChart();
        }

        public DisplayStatus getDefaultDisplayStatus() {
            return DisplayStatus.ALL;
        }

        public ListBoxModel doFillDisplayStatusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(DisplayStatus.ALL.getDescription(), DisplayStatus.ALL.getName());
            items.add(DisplayStatus.SUCCESS.getDescription(), DisplayStatus.SUCCESS.getName());
            items.add(DisplayStatus.FAILED.getDescription(), DisplayStatus.FAILED.getName());
            items.add(DisplayStatus.SKIPPED.getDescription(), DisplayStatus.SKIPPED.getName());
            return items;
        }
    }

    public static enum DisplayStatus {
        ALL("All"),
        SUCCESS("Success"),
        SKIPPED("Skipped"),
        FAILED("Failed");

        private final String description;

        private DisplayStatus(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name();
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), DisplayStatus.class);
        }
    }
}

