/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.stats;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class StatSlaves
extends DashboardPortlet {
    @DataBoundConstructor
    public StatSlaves(String name) {
        super(name);
    }

    @JavaScriptMethod
    public AgentStats getStats() {
        return new AgentStats(Jenkins.getActiveInstance());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_AgentStatistics();
        }
    }

    @ExportedBean
    public static final class AgentStats {
        @Exported
        public final int agents;
        @Exported
        public int onlineAgents = 0;
        @Exported
        public int offlineAgents = 0;
        @Exported
        public int disconnectedAgents = 0;
        @Exported
        public final int tasksInQueue;
        @Exported
        public final int runningJobs;

        AgentStats(Jenkins j) {
            this.agents = j.getNodes().size();
            this.countAgents(j.getComputers());
            this.tasksInQueue = j.getQueue().getApproximateItemsQuickly().size();
            this.runningJobs = this.countRunningJobs(j);
        }

        private void countAgents(Computer[] computers) {
            for (Computer computer : computers) {
                if (computer.isOnline()) {
                    ++this.onlineAgents;
                    continue;
                }
                if (computer.getConnectTime() != 0L) {
                    ++this.offlineAgents;
                    continue;
                }
                ++this.disconnectedAgents;
            }
            --this.onlineAgents;
        }

        private int countRunningJobs(Jenkins j) {
            List jobs = j.getAllItems(Job.class);
            int countRunningJobs = 0;
            for (Job job : jobs) {
                if (!job.isBuilding()) continue;
                ++countRunningJobs;
            }
            return countRunningJobs;
        }
    }
}

