/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.TopLevelItem;
import hudson.model.ViewDescriptor;
import hudson.plugins.view.dashboard.DashboardLog;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.security.stapler.StaplerDispatchable;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Dashboard
extends ListView {
    private boolean useCssStyle = false;
    private boolean includeStdJobList = false;
    private boolean hideJenkinsPanels = false;
    private String leftPortletWidth = "50%";
    private String rightPortletWidth = "50%";
    private List<DashboardPortlet> leftPortlets = new ArrayList<DashboardPortlet>();
    private List<DashboardPortlet> rightPortlets = new ArrayList<DashboardPortlet>();
    private List<DashboardPortlet> topPortlets = new ArrayList<DashboardPortlet>();
    private List<DashboardPortlet> bottomPortlets = new ArrayList<DashboardPortlet>();

    @DataBoundConstructor
    public Dashboard(String name) {
        super(name);
    }

    public boolean isUseCssStyle() {
        return this.useCssStyle;
    }

    public boolean isIncludeStdJobList() {
        return this.includeStdJobList;
    }

    public boolean isHideJenkinsPanels() {
        return this.hideJenkinsPanels;
    }

    @StaplerDispatchable
    public List<DashboardPortlet> getLeftPortlets() {
        return this.leftPortlets;
    }

    @StaplerDispatchable
    public List<DashboardPortlet> getRightPortlets() {
        return this.rightPortlets;
    }

    @StaplerDispatchable
    public List<DashboardPortlet> getTopPortlets() {
        return this.topPortlets;
    }

    @StaplerDispatchable
    public List<DashboardPortlet> getBottomPortlets() {
        return this.bottomPortlets;
    }

    public String getLeftPortletWidth() {
        return this.leftPortletWidth;
    }

    public String getRightPortletWidth() {
        return this.rightPortletWidth;
    }

    public String getPortletUrl(DashboardPortlet portlet) {
        int pos = this.topPortlets.indexOf(portlet);
        if (pos > -1) {
            return "topPortlets/" + pos;
        }
        pos = this.leftPortlets.indexOf(portlet);
        if (pos > -1) {
            return "leftPortlets/" + pos;
        }
        pos = this.rightPortlets.indexOf(portlet);
        if (pos > -1) {
            return "rightPortlets/" + pos;
        }
        pos = this.bottomPortlets.indexOf(portlet);
        if (pos > -1) {
            return "bottomPortlets/" + pos;
        }
        return "";
    }

    @Deprecated
    public DescriptorExtensionList<DashboardPortlet, Descriptor<DashboardPortlet>> getDashboardPortletDescriptors() {
        DescriptorExtensionList<DashboardPortlet, Descriptor<DashboardPortlet>> list = DashboardPortlet.all();
        return list;
    }

    public List<Descriptor<DashboardPortlet>> getSortedDashboardPortletDescriptors() {
        DescriptorExtensionList<DashboardPortlet, Descriptor<DashboardPortlet>> list = DashboardPortlet.all();
        ArrayList<Descriptor<DashboardPortlet>> descriptors = new ArrayList<Descriptor<DashboardPortlet>>((Collection<Descriptor<DashboardPortlet>>)list);
        Collections.sort(descriptors, new Comparator<Descriptor<DashboardPortlet>>(){

            @Override
            public int compare(Descriptor<DashboardPortlet> d1, Descriptor<DashboardPortlet> d2) {
                return d1.getDisplayName().compareTo(d2.getDisplayName());
            }
        });
        return descriptors;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="backwards compatibility, but seems unused internally.")
    public synchronized boolean HasItem(TopLevelItem item) {
        List items = this.getItems();
        return items.contains(item);
    }

    public synchronized List<Job> getJobs() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (TopLevelItem item : this.getItems()) {
            if (!(item instanceof Job)) continue;
            jobs.add((Job)item);
        }
        return jobs;
    }

    protected synchronized void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req);
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            DashboardLog.error("Dashboard", ex.getLocalizedMessage());
        }
        JSONObject json = req.getSubmittedForm();
        String sIncludeStdJobList = Util.nullify((String)req.getParameter("includeStdJobList"));
        this.includeStdJobList = sIncludeStdJobList != null && "on".equals(sIncludeStdJobList);
        String shideJenkinsPanels = Util.nullify((String)req.getParameter("hideJenkinsPanels"));
        this.hideJenkinsPanels = shideJenkinsPanels != null && "on".equals(shideJenkinsPanels);
        String sUseCssStyle = Util.nullify((String)req.getParameter("useCssStyle"));
        boolean bl = this.useCssStyle = sUseCssStyle != null && "on".equals(sUseCssStyle);
        if (this.useCssStyle) {
            if (req.getParameter("leftPortletWidth") != null) {
                this.leftPortletWidth = req.getParameter("leftPortletWidth");
            }
            if (req.getParameter("rightPortletWidth") != null) {
                this.rightPortletWidth = req.getParameter("rightPortletWidth");
            }
        } else {
            this.rightPortletWidth = "50%";
            this.leftPortletWidth = "50%";
        }
        this.topPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"topPortlet", DashboardPortlet.all());
        this.leftPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"leftPortlet", DashboardPortlet.all());
        this.rightPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"rightPortlet", DashboardPortlet.all());
        this.bottomPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"bottomPortlet", DashboardPortlet.all());
    }

    public void rename(String newName) throws Descriptor.FormException {
        super.rename(newName);
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Messages.Dashboard_DisplayName();
        }
    }
}

