/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.scm.CvsRepositoryLocationType;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public abstract class CvsRepositoryLocation
implements Describable<CvsRepositoryLocation>,
ExtensionPoint,
Serializable {
    private static final long serialVersionUID = 7852253189793815601L;
    private final CvsRepositoryLocationType locationType;
    private final String locationName;
    private final boolean useHeadIfNotFound;

    private CvsRepositoryLocation(CvsRepositoryLocationType locationType, String locationName, boolean useHeadIfNotFound) {
        this.locationType = locationType;
        this.locationName = locationName;
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    @Exported
    public CvsRepositoryLocationType getLocationType() {
        return this.locationType;
    }

    @Exported
    public String getLocationName() {
        return this.locationName;
    }

    @Exported
    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public Descriptor<CvsRepositoryLocation> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorOrDie(this.getClass());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locationName == null ? 0 : this.locationName.hashCode());
        result = 31 * result + (this.locationType == null ? 0 : this.locationType.hashCode());
        result = 31 * result + (this.useHeadIfNotFound ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CvsRepositoryLocation other = (CvsRepositoryLocation)obj;
        if (this.locationName == null ? other.locationName != null : !this.locationName.equals(other.locationName)) {
            return false;
        }
        if (this.locationType != other.locationType) {
            return false;
        }
        return this.useHeadIfNotFound == other.useHeadIfNotFound;
    }

    public static class BranchRepositoryLocation
    extends CvsRepositoryLocation {
        private static final long serialVersionUID = -3848435525964164564L;

        @DataBoundConstructor
        public BranchRepositoryLocation(String branchName, boolean useHeadIfNotFound) {
            super(CvsRepositoryLocationType.BRANCH, branchName, useHeadIfNotFound);
        }

        @Exported
        public String getBranchName() {
            return this.getLocationName();
        }

        @Exported
        public boolean isUseHeadIfBranchNotFound() {
            return this.isUseHeadIfNotFound();
        }

        @Extension
        public static class BranchRepositoryLocationDescriptor
        extends CvsRepositoryLocationDescriptor {
            public BranchRepositoryLocationDescriptor() {
                super(BranchRepositoryLocation.class, "Branch");
            }
        }
    }

    public static class TagRepositoryLocation
    extends CvsRepositoryLocation {
        private static final long serialVersionUID = 1165226806285930149L;

        @DataBoundConstructor
        public TagRepositoryLocation(String tagName, boolean useHeadIfNotFound) {
            super(CvsRepositoryLocationType.TAG, tagName, useHeadIfNotFound);
        }

        @Exported
        public String getTagName() {
            return this.getLocationName();
        }

        @Exported
        public boolean isUseHeadIfTagNotFound() {
            return this.isUseHeadIfNotFound();
        }

        @Extension
        public static class TagRepositoryLocationDescriptor
        extends CvsRepositoryLocationDescriptor {
            public TagRepositoryLocationDescriptor() {
                super(TagRepositoryLocation.class, "Tag");
            }
        }
    }

    public static class HeadRepositoryLocation
    extends CvsRepositoryLocation {
        private static final long serialVersionUID = -8309924574620513326L;

        @DataBoundConstructor
        public HeadRepositoryLocation() {
            super(CvsRepositoryLocationType.HEAD, null, false);
        }

        @Extension
        public static class HeadRepositoryLocationDescriptor
        extends CvsRepositoryLocationDescriptor {
            public HeadRepositoryLocationDescriptor() {
                super(HeadRepositoryLocation.class, "Head");
            }
        }
    }

    public static class CvsRepositoryLocationDescriptor
    extends Descriptor<CvsRepositoryLocation> {
        private String locationName;

        protected CvsRepositoryLocationDescriptor(Class<? extends CvsRepositoryLocation> clazz, String locationName) {
            super(clazz);
            this.locationName = locationName;
        }

        public String getDisplayName() {
            return this.locationName;
        }

        public DescriptorExtensionList<CvsRepositoryLocation, CvsRepositoryLocationDescriptor> getRepositoryLocationDescriptors() {
            return Jenkins.getActiveInstance().getDescriptorList(CvsRepositoryLocation.class);
        }
    }
}

