/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.AbstractCvsDescriptor;
import hudson.scm.CVSChangeLogParser;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.ChangeLogParser;
import hudson.scm.CvsAuthentication;
import hudson.scm.CvsChangeSet;
import hudson.scm.CvsFile;
import hudson.scm.CvsLog;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.CvsRepositoryLocation;
import hudson.scm.CvsRepositoryLocationType;
import hudson.scm.CvsRevisionState;
import hudson.scm.ExcludedRegion;
import hudson.scm.ICvs;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.scm.cvstagging.CvsTagAction;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.MasterToSlaveFileCallable;
import jenkins.scm.cvs.QuietPeriodCompleted;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.ConnectionIdentity;
import org.netbeans.lib.cvsclient.event.CVSListener;

public abstract class AbstractCvs
extends SCM
implements ICvs {
    protected static final DateFormat DATE_FORMATTER = new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z", Locale.UK);

    @Override
    public AbstractCvsDescriptor getDescriptor() {
        return (AbstractCvsDescriptor)super.getDescriptor();
    }

    public boolean isCheckoutCurrentTimestamp() {
        return false;
    }

    protected boolean checkout(CvsRepository[] repositories, boolean isFlatten, FilePath workspace, boolean canUseUpdate, Run<?, ?> build, String dateStamp, boolean pruneEmptyDirectories, boolean cleanOnFailedUpdate, TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment(listener);
        for (CvsRepository repository : repositories) {
            for (CvsRepositoryItem item : repository.getRepositoryItems()) {
                for (CvsModule cvsModule : item.getModules()) {
                    FilePath targetWorkspace;
                    boolean flatten;
                    String checkoutName = envVars.expand(cvsModule.getCheckoutName());
                    boolean localSubModule = checkoutName.contains("/") && cvsModule.isAlternativeCheckoutName();
                    int lastSlash = checkoutName.lastIndexOf("/");
                    boolean bl = flatten = isFlatten && !cvsModule.isAlternativeCheckoutName();
                    FilePath filePath = flatten ? workspace.getParent() : (targetWorkspace = localSubModule ? workspace.child(checkoutName.substring(0, lastSlash)) : workspace);
                    String moduleName = flatten ? workspace.getName() : (localSubModule ? checkoutName.substring(lastSlash + 1) : checkoutName);
                    FilePath module = targetWorkspace.child(moduleName);
                    boolean updateFailed = false;
                    boolean update = false;
                    if (flatten) {
                        if (workspace.child("CVS/Entries").exists()) {
                            update = true;
                        }
                    } else if (canUseUpdate && module.exists()) {
                        update = true;
                    }
                    CvsRepositoryLocation repositoryLocation = item.getLocation();
                    CvsRepositoryLocationType locationType = repositoryLocation.getLocationType();
                    String locationName = repositoryLocation.getLocationName();
                    String expandedLocationName = envVars.expand(locationName);
                    if (update) {
                        UpdateCommand updateCommand = new UpdateCommand();
                        updateCommand.setBuildDirectories(true);
                        updateCommand.setRecursive(true);
                        updateCommand.setPruneDirectories(pruneEmptyDirectories);
                        updateCommand.setCleanCopy(this.isForceCleanCopy());
                        if (locationType == CvsRepositoryLocationType.BRANCH) {
                            updateCommand.setUpdateByRevision(expandedLocationName);
                            if (repositoryLocation.isUseHeadIfNotFound()) {
                                updateCommand.setUseHeadIfNotFound(true);
                                updateCommand.setUpdateByDate(dateStamp);
                            }
                        } else if (locationType == CvsRepositoryLocationType.TAG) {
                            updateCommand.setUpdateByRevision(expandedLocationName);
                            updateCommand.setUseHeadIfNotFound(repositoryLocation.isUseHeadIfNotFound());
                        } else {
                            updateCommand.setUpdateByRevision(CvsRepositoryLocationType.HEAD.getName().toUpperCase());
                            updateCommand.setUpdateByDate(dateStamp);
                        }
                        if (!this.perform((Command)updateCommand, targetWorkspace, listener, repository, moduleName, envVars, pruneEmptyDirectories)) {
                            if (cleanOnFailedUpdate) {
                                updateFailed = true;
                            } else {
                                return false;
                            }
                        }
                    }
                    if (update && (!updateFailed || !cleanOnFailedUpdate)) continue;
                    if (updateFailed) {
                        listener.getLogger().println("Update failed. Cleaning workspace and performing full checkout");
                        workspace.deleteContents();
                    }
                    CheckoutCommand checkoutCommand = new CheckoutCommand();
                    if (locationType == CvsRepositoryLocationType.BRANCH) {
                        checkoutCommand.setCheckoutByRevision(expandedLocationName);
                        if (repositoryLocation.isUseHeadIfNotFound()) {
                            checkoutCommand.setUseHeadIfNotFound(true);
                            checkoutCommand.setCheckoutByDate(dateStamp);
                        }
                    } else if (locationType == CvsRepositoryLocationType.TAG) {
                        checkoutCommand.setCheckoutByRevision(expandedLocationName);
                        if (repositoryLocation.isUseHeadIfNotFound()) {
                            checkoutCommand.setUseHeadIfNotFound(true);
                        }
                    } else if (locationType == CvsRepositoryLocationType.HEAD) {
                        checkoutCommand.setCheckoutByDate(dateStamp);
                    }
                    checkoutCommand.setPruneDirectories(pruneEmptyDirectories);
                    if (cvsModule.isAlternativeCheckoutName() || flatten) {
                        checkoutCommand.setCheckoutDirectory(moduleName);
                    }
                    checkoutCommand.setModule(envVars.expand(cvsModule.getRemoteName()));
                    if (this.perform((Command)checkoutCommand, targetWorkspace, listener, repository, moduleName, envVars, pruneEmptyDirectories)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean perform(final Command cvsCommand, FilePath workspace, final TaskListener listener, CvsRepository repository, final String moduleName, EnvVars envVars, boolean pruneEmptyDirectories) throws IOException, InterruptedException {
        GlobalOptions globalOptions;
        final Client cvsClient = this.getCvsClient(repository, envVars, listener);
        if (!((Boolean)workspace.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Boolean>(globalOptions = this.getGlobalOptions(repository, envVars), pruneEmptyDirectories){
            private static final long serialVersionUID = -7517978923721181408L;
            final /* synthetic */ GlobalOptions val$globalOptions;
            final /* synthetic */ boolean val$pruneEmptyDirectories;
            {
                this.val$globalOptions = globalOptions;
                this.val$pruneEmptyDirectories = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean invoke(File workspace, VirtualChannel channel) throws RuntimeException {
                if (cvsCommand instanceof UpdateCommand) {
                    ((UpdateCommand)cvsCommand).setFiles(new File[]{new File(workspace, moduleName)});
                }
                listener.getLogger().println("cvs " + cvsCommand.getCVSCommand());
                cvsClient.setLocalPath(workspace.getAbsolutePath());
                BasicListener basicListener = new BasicListener(listener.getLogger(), listener.getLogger());
                cvsClient.getEventManager().addCVSListener((CVSListener)basicListener);
                try {
                    if (!cvsClient.executeCommand(cvsCommand, this.val$globalOptions)) {
                        Boolean bl = false;
                        return bl;
                    }
                    if (this.val$pruneEmptyDirectories && !AbstractCvs.this.isDisableCvsQuiet()) {
                        try {
                            File moduleDir = new File(workspace, moduleName);
                            if (moduleDir.isDirectory()) {
                                AbstractCvs.pruneEmptyDirectories(moduleDir, listener);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error("CVS empty directory cleanup failed: " + e.getMessage()));
                            Boolean ex = false;
                            try {
                                cvsClient.getConnection().close();
                            }
                            catch (IOException ex2) {
                                listener.error("Could not close client connection: " + ex2.getMessage());
                            }
                            return ex;
                        }
                    }
                    Boolean e = true;
                    return e;
                }
                catch (CommandAbortedException e) {
                    e.printStackTrace(listener.error("CVS Command aborted: " + e.getMessage()));
                    Boolean bl = false;
                    return bl;
                }
                catch (CommandException e) {
                    e.printStackTrace(listener.error("CVS Command failed: " + e.getMessage()));
                    Boolean bl = false;
                    return bl;
                }
                catch (AuthenticationException e) {
                    e.printStackTrace(listener.error("CVS Authentication failed: " + e.getMessage()));
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        cvsClient.getConnection().close();
                    }
                    catch (IOException ex) {
                        listener.error("Could not close client connection: " + ex.getMessage());
                    }
                }
            }
        })).booleanValue()) {
            listener.error("Cvs task failed");
            return false;
        }
        return true;
    }

    private static void pruneEmptyDirectories(File d, TaskListener listener) throws IOException {
        File[] kids = d.listFiles();
        if (kids == null) {
            throw new IOException("could not examine " + d);
        }
        for (File kid : kids) {
            if (!kid.isDirectory() || !new File(kid, "CVS").isDirectory()) continue;
            if (AbstractCvs.isSymLink(kid, listener)) {
                listener.getLogger().println("pruneEmptyDirectories. prevent potential infinate loop, ignoring symlink:" + kid);
                continue;
            }
            AbstractCvs.pruneEmptyDirectories(kid, listener);
            File[] subkids = kid.listFiles();
            if (subkids == null || subkids.length != 1) continue;
            Util.deleteRecursive((File)kid);
        }
    }

    public Client getCvsClient(CvsRepository repository, EnvVars envVars, TaskListener listener) {
        return this.getCvsClient(repository, envVars, listener, true);
    }

    public Client getCvsClient(CvsRepository repository, EnvVars envVars, TaskListener listener, boolean showAuthenticationInfo) {
        CVSRoot cvsRoot = CVSRoot.parse((String)envVars.expand(repository.getCvsRoot()));
        if (repository.isPasswordRequired()) {
            if (showAuthenticationInfo) {
                listener.getLogger().println("Using locally configured password for connection to " + cvsRoot.toString());
            }
            cvsRoot.setPassword(Secret.toString((Secret)repository.getPassword()));
        } else {
            String hostName = cvsRoot.getHostName();
            String partialRoot = (hostName != null ? hostName.toLowerCase(Locale.ENGLISH) : "") + ":" + ConnectionFactory.getConnection((CVSRoot)cvsRoot).getPort() + cvsRoot.getRepository();
            String sanitisedRoot = ":" + cvsRoot.getMethod() + ":" + partialRoot;
            for (CvsAuthentication authentication : this.getDescriptor().getAuthentication()) {
                CVSRoot authenticationRoot = CVSRoot.parse((String)authentication.getCvsRoot());
                String partialAuthenticationRoot = authenticationRoot.getHostName().toLowerCase(Locale.ENGLISH) + ":" + ConnectionFactory.getConnection((CVSRoot)authenticationRoot).getPort() + authenticationRoot.getRepository();
                String sanitisedAuthenticationRoot = ":" + cvsRoot.getMethod() + ":" + partialAuthenticationRoot;
                if (!sanitisedAuthenticationRoot.equals(sanitisedRoot) || cvsRoot.getUserName() != null && !authentication.getUsername().equals(cvsRoot.getUserName())) continue;
                cvsRoot = CVSRoot.parse((String)(":" + cvsRoot.getMethod() + ":" + (authentication.getUsername() != null ? authentication.getUsername() + "@" : "") + partialRoot));
                cvsRoot.setPassword(authentication.getPassword().getPlainText());
                if (!showAuthenticationInfo) break;
                listener.getLogger().println("Using globally configured password for connection to '" + sanitisedRoot + "' with username '" + authentication.getUsername() + "'");
                break;
            }
        }
        ConnectionIdentity connectionIdentity = ConnectionFactory.getConnectionIdentity();
        connectionIdentity.setKnownHostsFile(envVars.expand(this.getDescriptor().getKnownHostsLocation()));
        connectionIdentity.setPrivateKeyPath(envVars.expand(this.getDescriptor().getPrivateKeyLocation()));
        if (this.getDescriptor().getPrivateKeyPassword() != null) {
            connectionIdentity.setPrivateKeyPassword(this.getDescriptor().getPrivateKeyPassword().getPlainText());
        }
        Connection cvsConnection = ConnectionFactory.getConnection((CVSRoot)cvsRoot);
        return new Client(cvsConnection, (AdminHandler)new StandardAdminHandler());
    }

    public GlobalOptions getGlobalOptions(CvsRepository repository, EnvVars envVars) {
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setVeryQuiet(!this.isDisableCvsQuiet());
        globalOptions.setModeratelyQuiet(!this.isDisableCvsQuiet());
        globalOptions.setCompressionLevel(this.getCompressionLevel(repository, envVars));
        globalOptions.setCVSRoot(envVars.expand(repository.getCvsRoot()));
        return globalOptions;
    }

    private int getCompressionLevel(CvsRepository repository, EnvVars envVars) {
        String cvsroot = envVars.expand(repository.getCvsRoot());
        boolean local = cvsroot.startsWith("/") || cvsroot.startsWith(":local:") || cvsroot.startsWith(":fork:");
        int compressionLevel = repository.getCompressionLevel() == -1 ? this.getDescriptor().getCompressionLevel() : repository.getCompressionLevel();
        return local ? 0 : compressionLevel;
    }

    @Override
    public boolean isDisableCvsQuiet() {
        return true;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (SCMRevisionState)build.getAction(CvsRevisionState.class);
    }

    @CheckForNull
    public SCMRevisionState calcRevisionsFromBuild(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        return (SCMRevisionState)build.getAction(CvsRevisionState.class);
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline, CvsRepository[] repositories) throws IOException, InterruptedException {
        AbstractBuild build = project.getLastBuild();
        if (null == build) {
            listener.getLogger().println("No previous build found, scheduling build");
            return PollingResult.BUILD_NOW;
        }
        if (!build.hasChangeSetComputed() && build.isBuilding()) {
            listener.getLogger().println("Previous build has not finished checkout. Not triggering build as no valid baseline comparison available.");
            return PollingResult.NO_CHANGES;
        }
        EnvVars envVars = project.getLastBuild().getEnvironment(listener);
        Date currentPollDate = Calendar.getInstance().getTime();
        boolean changesPresent = false;
        if (baseline == null || !(baseline instanceof CvsRevisionState)) {
            listener.getLogger().println("Invalid baseline detected, scheduling build");
            return new PollingResult(baseline, (SCMRevisionState)new CvsRevisionState(new HashMap<CvsRepository, List<CvsFile>>()), PollingResult.Change.INCOMPARABLE);
        }
        HashMap<CvsRepository, List<CvsFile>> remoteState = new HashMap<CvsRepository, List<CvsFile>>(((CvsRevisionState)baseline).getModuleFiles());
        for (CvsRepository repository : repositories) {
            if (!remoteState.containsKey(repository)) {
                listener.getLogger().println("Repository not found in workspace state, scheduling build");
                return new PollingResult(baseline, (SCMRevisionState)new CvsRevisionState(new HashMap<CvsRepository, List<CvsFile>>()), PollingResult.Change.INCOMPARABLE);
            }
            List<CvsFile> changes = this.calculateRepositoryState(build.getTime(), currentPollDate, repository, listener, envVars, workspace);
            List remoteFiles = (List)remoteState.get(repository);
            for (CvsFile cvsFile : changes) {
                boolean changed = false;
                ListIterator<CvsFile> itr = remoteFiles.listIterator();
                while (itr.hasNext()) {
                    CvsFile existingFile = (CvsFile)itr.next();
                    if (!cvsFile.getName().equals(existingFile.getName())) continue;
                    itr.remove();
                    if (!cvsFile.isDead()) {
                        itr.add(cvsFile);
                    }
                    changed = true;
                }
                if (changed) continue;
                remoteFiles.add(cvsFile);
            }
            remoteState.put(repository, remoteFiles);
            ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
            for (ExcludedRegion pattern : repository.getExcludedRegions()) {
                try {
                    excludePatterns.add(Pattern.compile(pattern.getPattern()));
                }
                catch (PatternSyntaxException ex) {
                    listener.getLogger().println("Pattern could not be compiled: " + pattern);
                    throw new RuntimeException("Polling could not completed since pattern could not be compiled", ex);
                }
            }
            ArrayList<CvsFile> arrayList = new ArrayList<CvsFile>(changes);
            for (Pattern excludePattern : excludePatterns) {
                Iterator itr = arrayList.iterator();
                while (itr.hasNext()) {
                    CvsFile change = (CvsFile)itr.next();
                    if (!excludePattern.matcher(change.getName()).matches()) continue;
                    listener.getLogger().println("Skipping file '" + change.getName() + "' since it matches exclude pattern " + excludePattern.pattern());
                    itr.remove();
                }
            }
            changesPresent = changesPresent || !arrayList.isEmpty();
        }
        return new PollingResult(baseline, (SCMRevisionState)new CvsRevisionState(remoteState), changesPresent ? PollingResult.Change.SIGNIFICANT : PollingResult.Change.NONE);
    }

    protected List<CvsFile> calculateRepositoryState(Date startTime, Date endTime, CvsRepository repository, TaskListener listener, EnvVars envVars, FilePath workspace) throws IOException, InterruptedException {
        ArrayList<CvsFile> files = new ArrayList<CvsFile>();
        for (CvsRepositoryItem item : repository.getRepositoryItems()) {
            for (CvsModule module : item.getModules()) {
                files.addAll(this.getRemoteLogForModule(repository, item, module, startTime, endTime, envVars, listener, workspace).getFiles());
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CvsChangeSet getRemoteLogForModule(final CvsRepository repository, final CvsRepositoryItem item, CvsModule module, Date startTime, Date endTime, final EnvVars envVars, final TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        final Client cvsClient = this.getCvsClient(repository, envVars, listener);
        final RlogCommand rlogCommand = new RlogCommand();
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            String lastBuildDate = DATE_FORMATTER.format(startTime);
            String endDate = DATE_FORMATTER.format(endTime);
            rlogCommand.setDateFilter(lastBuildDate + "<" + endDate);
        }
        rlogCommand.setModule(envVars.expand(module.getRemoteName()));
        rlogCommand.setSuppressHeader(true);
        final String encoding = this.getDescriptor().getChangelogEncoding();
        final GlobalOptions globalOptions = this.getGlobalOptions(repository, envVars);
        if (workspace == null) {
            return this.executeRlog(cvsClient, rlogCommand, listener, encoding, globalOptions, repository, envVars, item.getLocation());
        }
        return (CvsChangeSet)workspace.act((FilePath.FileCallable)new MasterToSlaveFileCallable<CvsChangeSet>(){

            public CvsChangeSet invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                return AbstractCvs.this.executeRlog(cvsClient, rlogCommand, listener, encoding, globalOptions, repository, envVars, item.getLocation());
            }
        });
    }

    private CvsChangeSet executeRlog(Client cvsClient, RlogCommand rlogCommand, TaskListener listener, final String encoding, GlobalOptions globalOptions, CvsRepository repository, EnvVars envVars, CvsRepositoryLocation location) throws IOException {
        final File tmpRlogSpill = File.createTempFile("cvs", "rlog");
        final DeferredFileOutputStream outputStream = new DeferredFileOutputStream(102400, tmpRlogSpill);
        PrintStream logStream = new PrintStream((OutputStream)outputStream, true, encoding);
        BasicListener basicListener = new BasicListener(logStream, listener.getLogger());
        cvsClient.getEventManager().addCVSListener((CVSListener)basicListener);
        listener.getLogger().println("cvs " + rlogCommand.getCVSCommand());
        try {
            if (!cvsClient.executeCommand((Command)rlogCommand, globalOptions)) {
                this.cleanupLog(logStream, tmpRlogSpill);
                throw new RuntimeException("Error while trying to run CVS rlog");
            }
        }
        catch (CommandAbortedException e) {
            this.cleanupLog(logStream, tmpRlogSpill);
            throw new RuntimeException("CVS rlog command aborted", e);
        }
        catch (CommandException e) {
            this.cleanupLog(logStream, tmpRlogSpill);
            throw new RuntimeException("CVS rlog command failed", e);
        }
        catch (AuthenticationException e) {
            this.cleanupLog(logStream, tmpRlogSpill);
            throw new RuntimeException("CVS authentication failure while running rlog command", e);
        }
        finally {
            try {
                cvsClient.getConnection().close();
            }
            catch (IOException ex) {
                listener.error("Could not close CVS connection");
                ex.printStackTrace(listener.getLogger());
            }
            logStream.close();
        }
        CvsLog log = new CvsLog(){

            @Override
            public Reader read() throws IOException {
                if (outputStream.isInMemory()) {
                    return new InputStreamReader((InputStream)new ByteArrayInputStream(outputStream.getData()), encoding);
                }
                return new InputStreamReader((InputStream)new FileInputStream(outputStream.getFile()), encoding);
            }

            @Override
            public void dispose() {
                if (!tmpRlogSpill.delete()) {
                    tmpRlogSpill.deleteOnExit();
                }
            }
        };
        return log.mapCvsLog(envVars.expand(repository.getCvsRoot()), location, repository, envVars);
    }

    private void cleanupLog(PrintStream logStream, File tmpRlogSpill) {
        logStream.close();
        if (!tmpRlogSpill.delete()) {
            tmpRlogSpill.deleteOnExit();
        }
    }

    protected List<CVSChangeLogSet.CVSChangeLog> calculateChangeLog(Date startTime, Date endTime, CvsRepository repository, TaskListener listener, EnvVars envVars, FilePath workspace) throws IOException, InterruptedException {
        ArrayList<CVSChangeLogSet.CVSChangeLog> changes = new ArrayList<CVSChangeLogSet.CVSChangeLog>();
        for (CvsRepositoryItem item : repository.getRepositoryItems()) {
            for (CvsModule module : item.getModules()) {
                changes.addAll(this.getRemoteLogForModule(repository, item, module, startTime, endTime, envVars, listener, workspace).getChanges());
            }
        }
        return changes;
    }

    protected void postCheckout(Run<?, ?> build, File changelogFile, CvsRepository[] repositories, FilePath workspace, final TaskListener listener, boolean flatten, EnvVars envVars) throws IOException, InterruptedException {
        Run lastCompleteBuild = build.getPreviousBuiltBuild();
        if (lastCompleteBuild != null && !this.isSkipChangeLog()) {
            Date lastCompleteTimestamp = this.getCheckoutDate(lastCompleteBuild);
            Date checkoutDate = this.getCheckoutDate(build);
            ArrayList<CVSChangeLogSet.CVSChangeLog> changes = new ArrayList<CVSChangeLogSet.CVSChangeLog>();
            for (CvsRepository location : repositories) {
                changes.addAll(this.calculateChangeLog(lastCompleteTimestamp, checkoutDate, location, listener, build.getEnvironment(listener), workspace));
            }
            new CVSChangeLogSet(build, this.getBrowser(), changes).toFile(changelogFile);
        } else {
            this.createEmptyChangeLog(changelogFile, listener, "changelog");
        }
        build.getActions().add(new CvsRevisionState(this.calculateWorkspaceState(workspace, repositories, flatten, envVars, listener)));
        build.getActions().add(new CvsTagAction(build, this));
        for (CvsRepository repository : this.getRepositories()) {
            for (final CvsRepositoryItem repositoryItem : repository.getRepositoryItems()) {
                for (CvsModule module : repositoryItem.getModules()) {
                    FilePath target = flatten ? workspace : workspace.child(module.getCheckoutName());
                    target.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Void>(){

                        public Void invoke(File module, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                            StandardAdminHandler adminHandler = new StandardAdminHandler();
                            this.cleanup(module, (AdminHandler)adminHandler);
                            return null;
                        }

                        private void cleanup(File directory, AdminHandler adminHandler) throws IOException {
                            File[] innerFiles;
                            File tagFile;
                            for (File file : adminHandler.getAllFiles(directory)) {
                                Entry entry = adminHandler.getEntry(file);
                                entry.setTag(entry.getTag());
                                adminHandler.setEntry(file, entry);
                            }
                            if (repositoryItem.getLocation().getLocationType() == CvsRepositoryLocationType.HEAD && (tagFile = new File(directory, "CVS/Tag")).exists() && !tagFile.delete()) {
                                listener.getLogger().println("Could not delete the sticky tag file, workspace may be in an inconsistent state");
                            }
                            if (null != (innerFiles = directory.listFiles())) {
                                for (File innerFile : innerFiles) {
                                    if (AbstractCvs.isSymLink(innerFile, listener)) {
                                        listener.getLogger().println("cleanup. prevent potential infinate loop, ignoring symlink:" + innerFile);
                                        continue;
                                    }
                                    if (!innerFile.isDirectory() || innerFile.getName().equals("CVS")) continue;
                                    this.cleanup(innerFile, adminHandler);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    protected Date getCheckoutDate(Run<?, ?> build) {
        QuietPeriodCompleted quietPeriodCompleted = (QuietPeriodCompleted)build.getAction(QuietPeriodCompleted.class);
        Date checkoutDate = quietPeriodCompleted != null && !this.isCheckoutCurrentTimestamp() ? quietPeriodCompleted.getTimestampDate() : build.getTime();
        return checkoutDate;
    }

    private Map<CvsRepository, List<CvsFile>> calculateWorkspaceState(FilePath workspace, CvsRepository[] repositories, boolean flatten, EnvVars envVars, TaskListener listener) throws IOException, InterruptedException {
        HashMap<CvsRepository, List<CvsFile>> workspaceState = new HashMap<CvsRepository, List<CvsFile>>();
        for (CvsRepository repository : repositories) {
            ArrayList<CvsFile> cvsFiles = new ArrayList<CvsFile>();
            for (CvsRepositoryItem item : repository.getRepositoryItems()) {
                for (CvsModule module : item.getModules()) {
                    cvsFiles.addAll(this.getCvsFiles(workspace, module, flatten, envVars, listener));
                }
            }
            workspaceState.put(repository, cvsFiles);
        }
        return workspaceState;
    }

    public static boolean isSymLink(File file, TaskListener listener) {
        if (file == null) {
            return false;
        }
        try {
            File canon;
            if (file.getParent() == null) {
                canon = file;
            } else {
                File canonDir = file.getParentFile().getCanonicalFile();
                canon = new File(canonDir, file.getName());
            }
            return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
        }
        catch (IOException ex) {
            ex.printStackTrace(listener.error("Ignoring exception when checking for symlink. file:" + file + " exception:" + ex.getMessage()));
            return false;
        }
    }

    private List<CvsFile> getCvsFiles(FilePath workspace, final CvsModule module, boolean flatten, final EnvVars envVars, final TaskListener listener) throws IOException, InterruptedException {
        FilePath targetWorkspace = flatten ? workspace : workspace.child(envVars.expand(module.getCheckoutName()));
        return (List)targetWorkspace.act((FilePath.FileCallable)new MasterToSlaveFileCallable<List<CvsFile>>(){
            private static final long serialVersionUID = 8158155902777163137L;

            public List<CvsFile> invoke(File moduleLocation, VirtualChannel channel) throws IOException {
                return this.buildFileList(moduleLocation, envVars.expand(module.getRemoteName()));
            }

            public List<CvsFile> buildFileList(File moduleLocation, String prefix) throws IOException {
                StandardAdminHandler adminHandler = new StandardAdminHandler();
                ArrayList<CvsFile> fileList = new ArrayList<CvsFile>();
                if (moduleLocation.isFile()) {
                    Entry entry = adminHandler.getEntry(moduleLocation);
                    if (entry != null) {
                        fileList.add(CvsFile.make(entry.getName(), entry.getRevision()));
                    }
                } else {
                    for (File file : adminHandler.getAllFiles(moduleLocation)) {
                        if (!file.isFile()) continue;
                        Entry entry = adminHandler.getEntry(file);
                        CvsFile currentFile = CvsFile.make(prefix + "/" + entry.getName(), entry.getRevision());
                        fileList.add(currentFile);
                    }
                    File[] directoryFiles = moduleLocation.listFiles();
                    if (directoryFiles != null) {
                        for (File file : directoryFiles) {
                            if (!file.isDirectory()) continue;
                            if (!AbstractCvs.isSymLink(file, listener)) {
                                fileList.addAll(this.buildFileList(file, prefix + "/" + file.getName()));
                                continue;
                            }
                            listener.getLogger().println("buildFileList. prevent potential infinate loop, ignoring symlink:" + file);
                        }
                    }
                }
                return fileList;
            }
        });
    }

    public ChangeLogParser createChangeLogParser() {
        return new CVSChangeLogParser();
    }
}

