/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Util;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.CVSSCM;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.CvsRepositoryLocation;
import hudson.scm.ExcludedRegion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;

public class LegacyConvertor {
    private static LegacyConvertor instance;

    private LegacyConvertor() {
    }

    public List<CvsRepository> convertLegacyConfigToRepositoryStructure(String cvsRoot, String allModules, String branch, boolean isBranchActuallyTag, String excludedRegions, boolean useHeadIfNotFound, CVSRepositoryBrowser browser) {
        boolean isTag;
        ArrayList<CvsModule> modules = new ArrayList<CvsModule>();
        String nodeName = Util.fixNull((String)branch);
        boolean isBranch = !isBranchActuallyTag && !nodeName.equals("");
        boolean bl = isTag = isBranchActuallyTag && !nodeName.equals("");
        CvsRepositoryLocation location = isBranch ? new CvsRepositoryLocation.BranchRepositoryLocation(nodeName, useHeadIfNotFound) : (isTag ? new CvsRepositoryLocation.TagRepositoryLocation(nodeName, useHeadIfNotFound) : new CvsRepositoryLocation.HeadRepositoryLocation());
        for (String moduleName : this.convertModulesToList(allModules)) {
            modules.add(new CvsModule(moduleName, ""));
        }
        ArrayList<CvsRepository> repositories = new ArrayList<CvsRepository>();
        String password = this.getPassword(cvsRoot);
        ArrayList<CvsRepositoryItem> items = new ArrayList<CvsRepositoryItem>();
        items.add(new CvsRepositoryItem(location, modules.toArray(new CvsModule[modules.size()])));
        repositories.add(new CvsRepository(cvsRoot, password != null, password, items, this.convertExcludedRegionsToList(excludedRegions), -1, browser));
        return repositories;
    }

    public String getPassword(String cvsRoot) {
        String password;
        String customPassfileLocation = Util.fixNull((String)CVSSCM.DescriptorImpl.getOrDie().getCvsPassFile());
        File passFile = customPassfileLocation.equals("") ? new File(new File(System.getProperty("user.home")), ".cvspass") : new File(customPassfileLocation);
        if (!passFile.exists()) {
            return null;
        }
        try {
            password = this.findPassword(cvsRoot, passFile);
        }
        catch (IOException e) {
            return null;
        }
        if (null == password) {
            return null;
        }
        return StandardScrambler.getInstance().scramble(password.substring(1)).substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findPassword(String cvsRoot, File passFile) throws IOException {
        String password = null;
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(passFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("/1 ")) {
                    line = line.substring("/1 ".length());
                }
                int portIndex = line.indexOf(":2401/");
                if (line.startsWith(cvsRoot + " ")) {
                    password = line.substring(cvsRoot.length() + 1);
                } else {
                    if (portIndex <= 0) continue;
                    if ((line.substring(0, portIndex) + line.substring(portIndex + 5)).startsWith(cvsRoot + " ")) {
                        password = line.substring(cvsRoot.length() + 5 + 1);
                    } else {
                        if (!(line.substring(0, portIndex) + ":" + line.substring(portIndex + 5)).startsWith(cvsRoot + " ")) continue;
                        password = line.substring(cvsRoot.length() + 4 + 1);
                    }
                }
                break;
            }
        }
        return password;
    }

    public String[] convertModulesToList(String modules) {
        String[] moduleNames = modules.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < moduleNames.length; ++i) {
            moduleNames[i] = moduleNames[i].replaceAll("\\\\ ", " ");
        }
        return moduleNames;
    }

    public List<ExcludedRegion> convertExcludedRegionsToList(String excludedRegions) {
        String[] parts = excludedRegions == null ? new String[]{} : excludedRegions.split("[\\r\\n]+");
        ArrayList<ExcludedRegion> regions = new ArrayList<ExcludedRegion>();
        for (String part : parts) {
            regions.add(new ExcludedRegion(part));
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LegacyConvertor getInstance() {
        Class<LegacyConvertor> clazz = LegacyConvertor.class;
        synchronized (LegacyConvertor.class) {
            if (null == instance) {
                instance = new LegacyConvertor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

