/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ViewCVS
extends CVSRepositoryBrowser {
    public final URL url;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ViewCVS(URL url) throws MalformedURLException {
        this.url = ViewCVS.normalizeToEndWithSlash((URL)url);
    }

    @Override
    public URL getFileLink(CVSChangeLogSet.File file) throws IOException {
        return new URL(this.url, ViewCVS.trimHeadSlash((String)file.getName()) + this.param());
    }

    @Override
    public URL getDiffLink(CVSChangeLogSet.File file) throws IOException {
        CVSChangeLogSet.Revision r = new CVSChangeLogSet.Revision(file.getRevision());
        CVSChangeLogSet.Revision p = r.getPrevious();
        if (p == null) {
            return null;
        }
        return new URL(this.getFileLink(file), file.getSimpleName() + ".diff" + this.param().add("r1=" + p).add("r2=" + r));
    }

    public URL getChangeSetLink(CVSChangeLogSet.CVSChangeLog changeSet) throws IOException {
        return null;
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "ViewCVS";
        }
    }
}

