/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class ExcludedRegion
extends AbstractDescribableImpl<ExcludedRegion>
implements Serializable {
    private final String pattern;

    @DataBoundConstructor
    public ExcludedRegion(String pattern) {
        this.pattern = pattern;
    }

    @Exported
    public String getPattern() {
        return this.pattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcludedRegion other = (ExcludedRegion)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExcludedRegion> {
        public String getDisplayName() {
            return "Excluded regions";
        }

        public FormValidation doCheckPattern(@QueryParameter String value) {
            String v = Util.fixNull((String)value).trim();
            try {
                Pattern.compile(v);
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

